/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.encoding;

import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.http.encoding.IHTTPTransferCodingHandler;
import ej.hoka.io.ChunkedMessageBodyInputStream;
import ej.hoka.io.ChunkedMessageBodyOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChunkedTransferCodingHandler
implements IHTTPTransferCodingHandler {
    private static ChunkedTransferCodingHandler instance;

    private ChunkedTransferCodingHandler() {
    }

    public static ChunkedTransferCodingHandler getInstance() {
        if (instance == null) {
            instance = new ChunkedTransferCodingHandler();
        }
        return instance;
    }

    @Override
    public String getId() {
        return "chunked";
    }

    @Override
    public InputStream open(HTTPRequest request, InputStream input) throws IOException {
        return new ChunkedMessageBodyInputStream(input);
    }

    @Override
    public OutputStream open(HTTPResponse response, OutputStream output) throws IOException {
        return new ChunkedMessageBodyOutputStream(output);
    }
}

