/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.hoka.http.body.BodyParser;
import ej.hoka.http.body.ParameterParser;
import ej.hoka.http.encoding.HTTPEncodingRegistry;
import ej.hoka.http.encoding.IHTTPEncodingHandler;
import ej.hoka.http.encoding.IHTTPTransferCodingHandler;
import ej.hoka.http.encoding.UnsupportedHTTPEncodingException;
import ej.hoka.http.support.URLDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HTTPRequest {
    private static final int INITIAL_STRING_BUILDER_CAPACITY = 16;
    public static final int POST = 1;
    public static final int GET = 2;
    public static final int PUT = 3;
    public static final int DELETE = 4;
    private static final char SPACE_CHAR = ' ';
    private static final char PERCENTAGE_CHAR = '%';
    private static final char COLON_CHAR = ':';
    private static final String RESPONSE_COLON = ": ";
    private static final char NEWLINE_CHAR = '\n';
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char TABULATION_CHAR = '\t';
    private static final char QUESTION_MARK_CHAR = '?';
    private static final String MALFORMED_HTTP_REQUEST = "Malformed HTTP Request";
    private static final String CONNECTION_LOST = "Connection lost";
    private static final int INITIAL_MAP_CAPACITY = 10;
    private static final int INITIAL_URI_CAPACITY = 64;
    private static final int VERSION_SIZE = 10;
    private final int method;
    private final String uri;
    private final Map<String, String> parameters;
    private final String version;
    private final Map<String, String> header;
    private final InputStream body;
    private Map<String, String> cookies;

    protected HTTPRequest(InputStream inputStream, HTTPEncodingRegistry encodingRegistry) throws IOException {
        this.method = HTTPRequest.parseMethod(inputStream);
        this.parameters = new HashMap<String, String>(10);
        this.uri = HTTPRequest.parseURI(inputStream, this.parameters);
        this.version = HTTPRequest.parseVersion(inputStream);
        this.header = HTTPRequest.parseHeaderFields(inputStream);
        this.body = this.getContentEncodingStream(inputStream, encodingRegistry);
    }

    public int getMethod() {
        return this.method;
    }

    public String getURI() {
        return this.uri;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, String> getHeader() {
        return Collections.unmodifiableMap(this.header);
    }

    public String getHeaderField(String name) {
        if (name == null) {
            return null;
        }
        return this.header.get(name.toLowerCase());
    }

    public Map<String, String> getCookies() {
        if (this.cookies == null) {
            this.cookies = HTTPRequest.parseCookies(this.header.get("cookie"));
        }
        return this.cookies;
    }

    public String getCookie(String name) {
        if (name == null) {
            return null;
        }
        return this.getCookies().get(name);
    }

    public <T> T parseBody(BodyParser<T> bodyParser) throws IOException {
        return bodyParser.parseBody(this.body, this.getHeaderField("content-type"));
    }

    private InputStream getContentEncodingStream(InputStream in, HTTPEncodingRegistry encodingRegistry) throws IOException {
        String transferEncoding = this.getHeaderField("transfer-encoding");
        IHTTPTransferCodingHandler transferCodingHandler = encodingRegistry.getTransferCodingHandler(transferEncoding);
        if (transferCodingHandler == null) {
            throw new UnsupportedHTTPEncodingException("501 Not Implemented", "transfer-encoding: " + transferEncoding);
        }
        in = transferCodingHandler.open(this, in);
        String contentEncoding = this.getHeaderField("content-encoding");
        if (contentEncoding != null) {
            IHTTPEncodingHandler handler = encodingRegistry.getEncodingHandler(contentEncoding);
            if (handler == null) {
                throw new UnsupportedHTTPEncodingException("501 Not Implemented", "transfer-encoding: " + contentEncoding);
            }
            in = handler.open(in);
        }
        return in;
    }

    private static int parseMethod(InputStream input) throws IOException {
        String inputMethod;
        int read;
        StringBuilder builder = new StringBuilder();
        while ((read = input.read()) != 32) {
            if (read == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            builder.append((char)read);
        }
        switch (inputMethod = builder.toString().toUpperCase()) {
            case "GET": {
                return 2;
            }
            case "POST": {
                return 1;
            }
            case "PUT": {
                return 3;
            }
            case "DELETE": {
                return 4;
            }
        }
        throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
    }

    private static String parseURI(InputStream input, Map<String, String> parameters) throws IOException {
        StringBuilder sb = new StringBuilder(Math.min(64, input.available()));
        block5: while (true) {
            int i;
            if ((i = input.read()) == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            switch (i) {
                case 63: {
                    ParameterParser.parseParameters(input, parameters);
                    break block5;
                }
                case 32: {
                    break block5;
                }
                case 37: {
                    i = URLDecoder.decode(input, sb);
                }
                default: {
                    sb.append((char)i);
                    continue block5;
                }
            }
            break;
        }
        return sb.toString();
    }

    private static String parseVersion(InputStream input) throws IOException {
        byte[] version = new byte[10];
        int readBytes = 0;
        while (readBytes < 10) {
            int r = input.read(version, readBytes, 10 - readBytes);
            if (r == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            readBytes += r;
        }
        return new String(version, 0, 8);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Map<String, String> parseHeaderFields(InputStream input) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(10);
        StringBuilder sbKey = new StringBuilder(16);
        StringBuilder sbValue = new StringBuilder(16);
        StringBuilder curBuffer = sbKey;
        boolean pendingSpace = false;
        int i = input.read();
        block6: while (true) {
            if (i == -1) {
                throw new IOException(CONNECTION_LOST);
            }
            switch (i) {
                case 37: {
                    if (curBuffer != sbKey) break;
                    throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
                }
                case 58: {
                    if (curBuffer != sbKey) break;
                    curBuffer = sbValue;
                    i = input.read();
                    continue block6;
                }
                case 9: 
                case 32: {
                    pendingSpace = true;
                    i = input.read();
                    continue block6;
                }
                case 13: {
                    i = input.read();
                    if (i != 10) {
                        throw new IllegalArgumentException(MALFORMED_HTTP_REQUEST);
                    }
                    if (sbKey.length() == 0 && sbValue.length() == 0) {
                        return header;
                    }
                    i = input.read();
                    if (i == -1) {
                        throw new IOException(CONNECTION_LOST);
                    }
                    if (i == 32 || i == 9) continue block6;
                    if (sbKey.charAt(sbKey.length() - 1) != '*') {
                        header.put(sbKey.toString().toLowerCase(), sbValue.toString());
                    }
                    sbValue.delete(0, sbValue.length());
                    sbKey.delete(0, sbKey.length());
                    curBuffer = sbKey;
                    continue block6;
                }
            }
            if (pendingSpace) {
                pendingSpace = false;
                if (curBuffer.length() > 0) {
                    curBuffer.append(' ');
                }
            }
            curBuffer.append((char)i);
            i = input.read();
        }
    }

    private static Map<String, String> parseCookies(String cookiesHeader) {
        int next;
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (cookiesHeader == null) {
            return cookies;
        }
        int prev = 0;
        while (prev != -1 && (next = cookiesHeader.indexOf(61, prev)) != -1) {
            String name = cookiesHeader.substring(prev, next);
            String value = cookiesHeader.substring(next + 1);
            cookies.put(name, value);
            prev = cookiesHeader.indexOf(59, next);
        }
        return cookies;
    }
}

