/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.auth.session;

import ej.hoka.auth.SessionAuthenticator;
import ej.hoka.http.HTTPRequest;
import ej.hoka.http.HTTPResponse;
import ej.hoka.rest.RestEndpoint;
import java.util.Map;

public abstract class LogoutEndpoint
extends RestEndpoint {
    private final SessionAuthenticator sessionAuthenticator;

    public LogoutEndpoint(String uri, SessionAuthenticator sessionAuthenticator) {
        super(uri);
        this.sessionAuthenticator = sessionAuthenticator;
    }

    @Override
    public HTTPResponse get(HTTPRequest request, Map<String, String> attributes) {
        String sessionID = this.getSessionID(request, attributes);
        if (sessionID == null) {
            return this.failedLogoutResponse(request, attributes);
        }
        if (!this.sessionAuthenticator.logout(sessionID)) {
            return this.setLoggedOut(this.failedLogoutResponse(request, attributes));
        }
        return this.setLoggedOut(this.successfulLogoutResponse(request, attributes));
    }

    protected String getSessionID(HTTPRequest request, Map<String, String> attributes) {
        return request.getCookie("token");
    }

    protected abstract HTTPResponse successfulLogoutResponse(HTTPRequest var1, Map<String, String> var2);

    protected abstract HTTPResponse failedLogoutResponse(HTTPRequest var1, Map<String, String> var2);

    protected HTTPResponse setLoggedOut(HTTPResponse response) {
        response.addHeaderField("Set-Cookie", "token=; expires=Thu, 01 Jan 1970 00:00:00 GMT");
        return response;
    }
}

