/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.auth;

import ej.basictool.map.PackedMap;
import ej.hoka.auth.Session;
import ej.hoka.auth.SessionDataAccess;

public class InMemorySessionDataAccess
implements SessionDataAccess {
    private final PackedMap<String, String> activeSessionIDs = new PackedMap();
    private final PackedMap<String, String> activeUserIDs = new PackedMap();
    private final PackedMap<String, Long> activeSessionExp = new PackedMap();

    @Override
    public void addSession(Session session) {
        this.activeSessionIDs.put((Object)session.userID, (Object)session.sessionID);
        this.activeUserIDs.put((Object)session.sessionID, (Object)session.userID);
        this.activeSessionExp.put((Object)session.sessionID, (Object)session.sessionExpiration);
    }

    @Override
    public Session getSessionByUser(String userID) {
        if (userID == null || !this.activeSessionIDs.containsKey((Object)userID)) {
            return null;
        }
        String sessionID = (String)this.activeSessionIDs.get((Object)userID);
        Long sessionExp = (Long)this.activeSessionExp.get((Object)sessionID);
        return new Session(userID, sessionID, sessionExp);
    }

    @Override
    public Session getSessionByID(String sessionID) {
        if (sessionID == null || !this.activeUserIDs.containsKey((Object)sessionID)) {
            return null;
        }
        String userID = (String)this.activeUserIDs.get((Object)sessionID);
        Long sessionExp = (Long)this.activeSessionExp.get((Object)sessionID);
        return new Session(userID, sessionID, sessionExp);
    }

    @Override
    public void refreshSession(String sessionID, long newExpiration) {
        this.activeSessionExp.put((Object)sessionID, (Object)newExpiration);
    }

    @Override
    public void removeSession(Session session) {
        this.activeSessionIDs.remove((Object)session.userID);
        this.activeUserIDs.remove((Object)session.sessionID);
        this.activeSessionExp.remove((Object)session.sessionID);
    }
}

