/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.internal.ArrayComparisonFailure;

public abstract class ComparisonCriteria {
    public void arrayEquals(String message, Object expecteds, Object actuals) throws ArrayComparisonFailure {
        if (expecteds == actuals || Arrays.deepEquals(new Object[]{expecteds}, new Object[]{actuals})) {
            return;
        }
        String header = message == null ? "" : String.valueOf(message) + ": ";
        int expectedsLength = this.assertArraysAreSameLength(expecteds, actuals, header);
        int i = 0;
        while (i < expectedsLength) {
            Object expected = this._Array_get(expecteds, i);
            Object actual = this._Array_get(actuals, i);
            if (this.isArray(expected) && this.isArray(actual)) {
                try {
                    this.arrayEquals(message, expected, actual);
                }
                catch (ArrayComparisonFailure e) {
                    e.addDimension(i);
                    throw e;
                }
            }
            try {
                this.assertElementsEqual(expected, actual);
            }
            catch (AssertionError e) {
                throw new ArrayComparisonFailure(header, e, i);
            }
            ++i;
        }
    }

    private boolean isArray(Object expected) {
        return expected != null && expected.getClass().isArray();
    }

    private int assertArraysAreSameLength(Object expecteds, Object actuals, String header) {
        int expectedsLength;
        int actualsLength;
        if (expecteds == null) {
            Assert.fail(String.valueOf(header) + "expected array was null");
        }
        if (actuals == null) {
            Assert.fail(String.valueOf(header) + "actual array was null");
        }
        if ((actualsLength = this._Array_getLength(actuals)) != (expectedsLength = this._Array_getLength(expecteds))) {
            Assert.fail(String.valueOf(header) + "array lengths differed, expected.length=" + expectedsLength + " actual.length=" + actualsLength);
        }
        return expectedsLength;
    }

    private int _Array_getLength(Object array) {
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        throw new AssertionError((Object)"Not an array");
    }

    private Object _Array_get(Object array, int i) {
        if (array instanceof Object[]) {
            return ((Object[])array)[i];
        }
        if (array instanceof byte[]) {
            return new Byte(((byte[])array)[i]);
        }
        if (array instanceof short[]) {
            return new Short(((short[])array)[i]);
        }
        if (array instanceof int[]) {
            return new Integer(((int[])array)[i]);
        }
        if (array instanceof long[]) {
            return new Long(((long[])array)[i]);
        }
        if (array instanceof char[]) {
            return new Character(((char[])array)[i]);
        }
        if (array instanceof float[]) {
            return new Float(((float[])array)[i]);
        }
        if (array instanceof double[]) {
            return new Double(((double[])array)[i]);
        }
        if (array instanceof boolean[]) {
            return new Boolean(((boolean[])array)[i]);
        }
        throw new AssertionError((Object)"Not an array");
    }

    protected abstract void assertElementsEqual(Object var1, Object var2);
}

