/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.tcp;

import ej.annotation.Nullable;
import ej.hoka.log.HokaLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;

public class TcpServer {
    private static final int DEFAULT_TIMEOUT_DURATION = 60000;
    private static final String DEFAULT_ADDRESS = "0.0.0.0";
    private final int port;
    private final int maxOpenedConnections;
    private final ServerSocketFactory serverSocketFactory;
    private final int timeout;
    @Nullable
    private ServerSocket serverSocket;
    @Nullable
    private Thread thread;
    private Socket[] streamConnections;
    private int lastAddedPtr;
    private int lastReadPtr;

    public TcpServer(int port, int maxOpenedConnections) {
        this(port, maxOpenedConnections, ServerSocketFactory.getDefault());
    }

    public TcpServer(int port, int maxOpenedConnections, ServerSocketFactory serverSocketFactory) {
        this(port, maxOpenedConnections, serverSocketFactory, 60000);
    }

    public TcpServer(int port, int maxOpenedConnections, ServerSocketFactory serverSocketFactory, int timeout) {
        if (maxOpenedConnections <= 0 || timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.port = port;
        this.maxOpenedConnections = maxOpenedConnections;
        this.serverSocketFactory = serverSocketFactory;
        this.timeout = timeout;
        this.streamConnections = new Socket[this.maxOpenedConnections + 1];
    }

    public void start() throws IOException {
        if (!this.isStopped()) {
            throw new IllegalStateException();
        }
        this.streamConnections = new Socket[this.maxOpenedConnections + 1];
        this.lastAddedPtr = 0;
        this.lastReadPtr = 0;
        this.serverSocket = this.serverSocketFactory.createServerSocket(this.port);
        this.thread = new Thread(this.newProcess(), this.getName());
        this.thread.start();
        String host = DEFAULT_ADDRESS;
        InetAddress address = this.getInetAddress();
        if (address != null) {
            host = address.getHostAddress();
        }
        HokaLogger.instance.info("Server started " + host + ":" + this.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            ServerSocket server = this.serverSocket;
            this.serverSocket = null;
            try {
                if (server != null) {
                    server.close();
                }
            }
            catch (IOException e) {
                HokaLogger.instance.error(e);
                this.thread = null;
                return;
            }
            Thread t = this.thread;
            try {
                if (t != null) {
                    t.join();
                }
            }
            catch (InterruptedException e) {
                HokaLogger.instance.error(e);
                t.interrupt();
            }
        }
        finally {
            this.thread = null;
        }
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            this.streamConnections.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            HokaLogger.instance.debug("server stopped");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Socket connection) {
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            int nextPtr = this.lastAddedPtr + 1;
            if (nextPtr == this.streamConnections.length) {
                nextPtr = 0;
            }
            if (nextPtr == this.lastReadPtr) {
                HokaLogger.instance.error("too many connections max is:" + this.maxOpenedConnections);
                this.tooManyOpenConnections(connection);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            String host = DEFAULT_ADDRESS;
            InetAddress address = connection.getInetAddress();
            if (address != null) {
                host = address.getHostAddress();
            }
            HokaLogger.instance.trace(String.valueOf(connection.hashCode()) + "\t" + host + "\t connection received");
            this.streamConnections[nextPtr] = connection;
            this.lastAddedPtr = nextPtr;
            this.streamConnections.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Socket getNextStreamConnection() {
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            while (true) {
                if (this.lastAddedPtr != this.lastReadPtr) {
                    int nextPtr = this.lastReadPtr + 1;
                    if (nextPtr == this.streamConnections.length) {
                        nextPtr = 0;
                    }
                    Socket connection = this.streamConnections[nextPtr];
                    this.lastReadPtr = nextPtr;
                    this.streamConnections[nextPtr] = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return connection;
                }
                if (this.isStopped()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                try {
                    this.streamConnections.wait();
                }
                catch (InterruptedException e) {
                    HokaLogger.instance.error(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean isStopped() {
        return this.serverSocket == null || this.thread == null;
    }

    protected String getName() {
        return TcpServer.class.getSimpleName();
    }

    protected void tooManyOpenConnections(Socket connection) {
        try {
            connection.close();
        }
        catch (IOException e) {
            HokaLogger.instance.error(e);
        }
    }

    private Runnable newProcess() {
        return new Runnable(){

            @Override
            public void run() {
                boolean running = true;
                while (running) {
                    if (TcpServer.this.isStopped()) break;
                    try {
                        ServerSocket serverSocket = TcpServer.this.serverSocket;
                        if (serverSocket == null) continue;
                        Socket connection = serverSocket.accept();
                        connection.setSoTimeout(TcpServer.this.timeout);
                        TcpServer.this.addConnection(connection);
                    }
                    catch (IOException e) {
                        if (TcpServer.this.isStopped()) {
                            running = false;
                        }
                        if (!running) continue;
                        HokaLogger.instance.error(e);
                    }
                }
            }
        };
    }

    public int getPort() {
        return this.serverSocket != null ? this.serverSocket.getLocalPort() : -1;
    }

    @Nullable
    public InetAddress getInetAddress() {
        return this.serverSocket != null ? this.serverSocket.getInetAddress() : null;
    }
}

