/*
 * Decompiled with CFR 0.152.
 */
package ej.rest.web.mime;

import ej.rest.web.AbstractContent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class MultipartContent
extends AbstractContent {
    private final String subType;
    private final List<AbstractContent> parts;
    private final String boundary = "jb" + MultipartContent.randomUUID();

    public MultipartContent(String aSubtype, AbstractContent ... content) {
        this.subType = aSubtype;
        this.parts = new ArrayList<AbstractContent>(Arrays.asList(content));
    }

    @Override
    protected void addContent(URLConnection con) throws IOException {
        con.setDoOutput(true);
        con.addRequestProperty("Content-Type", "multipart/" + this.subType + "; boundary=" + this.boundary);
        OutputStream os = con.getOutputStream();
        this.writeContent(os);
        os.close();
    }

    @Override
    public void writeContent(OutputStream os) throws IOException {
        if (this.parts.isEmpty()) {
            return;
        }
        for (AbstractContent c : this.parts) {
            os.write(this.ascii("--"));
            os.write(this.ascii(this.boundary));
            os.write(CRLF);
            c.writeHeader(os);
            os.write(CRLF);
            c.writeContent(os);
            os.write(CRLF);
        }
        os.write(this.ascii("--"));
        os.write(this.ascii(this.boundary));
        os.write(this.ascii("--"));
        os.write(CRLF);
    }

    @Override
    public void writeHeader(OutputStream os) throws IOException {
        os.write(this.ascii("Content-Type: multipart/" + this.subType + "; boundary=" + this.boundary + "\r\n"));
    }

    private static String randomUUID() {
        Random ng = new Random();
        byte[] randomBytes = new byte[16];
        ng.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        int i = 0;
        while (i < 8) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
            ++i;
        }
        i = 8;
        while (i < 16) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
            ++i;
        }
        return MultipartContent.uuidtoString(msb, lsb);
    }

    private static String uuidtoString(long mostSigBits, long leastSigBits) {
        return String.valueOf(MultipartContent.digits(mostSigBits >> 32, 8)) + "-" + MultipartContent.digits(mostSigBits >> 16, 4) + "-" + MultipartContent.digits(mostSigBits, 4) + "-" + MultipartContent.digits(leastSigBits >> 48, 4) + "-" + MultipartContent.digits(leastSigBits, 12);
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }
}

