/*
 * Decompiled with CFR 0.152.
 */
package ej.rest.web;

import ej.rest.web.AbstractContent;
import ej.rest.web.AbstractResource;
import ej.rest.web.BinaryResource;
import ej.rest.web.ChunkedContent;
import ej.rest.web.Content;
import ej.rest.web.Deletion;
import ej.rest.web.FormContent;
import ej.rest.web.FormData;
import ej.rest.web.JSONPathQuery;
import ej.rest.web.JSONResource;
import ej.rest.web.Replacement;
import ej.rest.web.TextResource;
import ej.rest.web.mime.MultipartContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.json.me.JSONArray;
import org.json.me.JSONObject;

public class Resty {
    protected static String MOZILLA = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; en-US; rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13";
    protected static String DEFAULT_USER_AGENT = "Resty/0.1 (Java)";
    protected String userAgent = DEFAULT_USER_AGENT;
    private Map<String, String> additionalHeaders;
    private Option[] options;

    public Resty(Option ... someOptions) {
        this.setOptions(someOptions);
    }

    public Resty setOptions(Option ... someOptions) {
        Option[] optionArray = this.options = someOptions == null ? new Option[]{} : someOptions;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            Option o = optionArray[n2];
            o.init(this);
            ++n2;
        }
        return this;
    }

    public Resty identifyAsMozilla() {
        this.userAgent = MOZILLA;
        return this;
    }

    public Resty identifyAsResty() {
        this.userAgent = DEFAULT_USER_AGENT;
        return this;
    }

    public JSONResource json(String string) throws IOException {
        return this.json(URI.create(string));
    }

    public JSONResource json(URI anUri) throws IOException {
        return this.doGET(anUri, this.createJSONResource());
    }

    protected JSONResource createJSONResource() {
        return new JSONResource(this.options);
    }

    public JSONResource json(URI anUri, AbstractContent requestContent) throws IOException {
        return this.doPOSTOrPUT(anUri, requestContent, this.createJSONResource());
    }

    public JSONResource json(String anUri, AbstractContent content) throws IOException {
        return this.json(URI.create(anUri), content);
    }

    public TextResource text(URI anUri) throws IOException {
        return this.doGET(anUri, this.createTextResource());
    }

    protected TextResource createTextResource() {
        return new TextResource(this.options);
    }

    public TextResource text(URI anUri, AbstractContent content) throws IOException {
        return this.doPOSTOrPUT(anUri, content, this.createTextResource());
    }

    public TextResource text(String anUri) throws IOException {
        return this.text(URI.create(anUri));
    }

    public TextResource text(String anUri, AbstractContent content) throws IOException {
        return this.text(URI.create(anUri), content);
    }

    public BinaryResource bytes(String anUri) throws IOException {
        return this.bytes(URI.create(anUri));
    }

    public BinaryResource bytes(URI anUri) throws IOException {
        return this.doGET(anUri, this.createBinaryResource());
    }

    protected BinaryResource createBinaryResource() {
        return new BinaryResource(this.options);
    }

    public BinaryResource bytes(String anUri, AbstractContent someContent) throws IOException {
        return this.bytes(URI.create(anUri), someContent);
    }

    public BinaryResource bytes(URI anUri, AbstractContent someContent) throws IOException {
        return this.doPOSTOrPUT(anUri, someContent, this.createBinaryResource());
    }

    protected <T extends AbstractResource> T doGET(URI anUri, T resource) throws IOException {
        URLConnection con = this.openConnection(anUri, resource);
        return this.fillResourceFromURL(con, resource);
    }

    protected <T extends AbstractResource> T doPOSTOrPUT(URI anUri, AbstractContent requestContent, T resource) throws IOException {
        URLConnection con = this.openConnection(anUri, resource);
        requestContent.addContent(con);
        return this.fillResourceFromURL(con, resource);
    }

    protected <T extends AbstractResource> URLConnection openConnection(URI anUri, T resource) throws IOException, MalformedURLException {
        URL url = new URL(anUri.toString());
        URLConnection con = url.openConnection();
        this.addStandardHeaders(con, resource);
        this.addAdditionalHeaders(con);
        Option[] optionArray = this.options;
        int n = this.options.length;
        int n2 = 0;
        while (n2 < n) {
            Option o = optionArray[n2];
            o.apply(con);
            ++n2;
        }
        return con;
    }

    protected void addAdditionalHeaders(URLConnection con) {
        for (Map.Entry<String, String> header : this.getAdditionalHeaders().entrySet()) {
            con.addRequestProperty(header.getKey(), header.getValue());
        }
    }

    protected <T extends AbstractResource> void addStandardHeaders(URLConnection con, T resource) {
        con.setRequestProperty("User-Agent", this.userAgent);
        con.setRequestProperty("Accept", resource.getAcceptedTypes());
    }

    protected <T extends AbstractResource> T fillResourceFromURL(URLConnection con, T resource) throws IOException {
        resource.fill(con);
        resource.getAdditionalHeaders().putAll(this.getAdditionalHeaders());
        return resource;
    }

    public static JSONPathQuery path(String string) {
        return new JSONPathQuery(string);
    }

    public static Content content(JSONObject someJson) {
        Content c = null;
        try {
            c = new Content("application/json; charset=UTF-8", someJson.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return c;
    }

    public static Content content(JSONArray someJson) {
        Content c = null;
        try {
            c = new Content("application/json; charset=UTF-8", someJson.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return c;
    }

    public static Content content(String somePlainText) {
        Content c = null;
        try {
            c = new Content("text/plain; charset=UTF-8", somePlainText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return c;
    }

    public static Content content(byte[] bytes) {
        return new Content("application/octet-stream", bytes);
    }

    public static FormContent form(String query) {
        FormContent fc = new FormContent(query);
        return fc;
    }

    public static MultipartContent form(FormData ... formData) {
        MultipartContent mc = new MultipartContent("form-data", formData);
        return mc;
    }

    public static FormData data(String name, String plainTextValue) {
        return Resty.data(name, Resty.content(plainTextValue));
    }

    public static FormData data(String name, AbstractContent content) {
        return new FormData(name, content);
    }

    public static ChunkedContent chunked(String mime, InputStream stream) {
        return new ChunkedContent(mime, stream, -1);
    }

    public static ChunkedContent chunked(String mime, InputStream stream, int chunkSize) {
        return new ChunkedContent(mime, stream, chunkSize);
    }

    public static AbstractContent put(Content someContent) {
        return new Replacement(someContent);
    }

    public static AbstractContent delete() {
        return new Deletion();
    }

    @Deprecated
    public void alwaysSend(String aHeader, String aValue) {
        this.getAdditionalHeaders().put(aHeader, aValue);
    }

    public void withHeader(String aHeader, String aValue) {
        this.getAdditionalHeaders().put(aHeader, aValue);
    }

    public void dontSend(String aHeader) {
        this.getAdditionalHeaders().remove(aHeader);
    }

    protected Map<String, String> getAdditionalHeaders() {
        if (this.additionalHeaders == null) {
            this.additionalHeaders = new HashMap<String, String>();
        }
        return this.additionalHeaders;
    }

    public static abstract class Option {
        public void apply(URLConnection aConnection) {
        }

        public void init(Resty resty) {
        }

        public static Timeout timeout(int t) {
            return new Timeout(t);
        }
    }

    public static class Timeout
    extends Option {
        private final int timeout;

        public Timeout(int t) {
            this.timeout = t;
        }

        @Override
        public void apply(URLConnection urlConnection) {
            urlConnection.setConnectTimeout(this.timeout);
        }
    }
}

