/*
 * Decompiled with CFR 0.152.
 */
package ej.jsonpath.parser;

import ej.jsonpath.parser.JSONPathCompiler;
import java.util.List;
import org.json.me.JSONException;
import org.json.me.JSONObject;

public class Predicates {

    static class Existence
    implements Test {
        Existence() {
        }

        @Override
        public boolean test(JSONObject json) throws JSONException {
            return false;
        }
    }

    static class Identity
    implements Test {
        Test child;

        Identity(Test aChild) {
            this.child = aChild;
        }

        @Override
        public boolean test(JSONObject json) throws JSONException {
            return this.child.test(json);
        }
    }

    static class Operator
    implements Test {
        JSONPathCompiler.JSONPathExpr lhs;
        char ops;
        JSONPathCompiler.JSONPathExpr rhs;

        Operator(JSONPathCompiler.JSONPathExpr aSubExpr, String anOperator, JSONPathCompiler.JSONPathExpr aValue) {
            this.lhs = aSubExpr;
            this.ops = anOperator.charAt(0);
            this.rhs = aValue;
        }

        public String toString() {
            return this.lhs + " " + this.ops + " " + this.rhs;
        }

        @Override
        public boolean test(JSONObject json) throws JSONException {
            Object eval = this.lhs.eval(json);
            if (eval instanceof List) {
                List results = (List)eval;
                for (Object o : results) {
                    boolean result = this.compare(json, (Comparable)o);
                    if (!result) continue;
                    return true;
                }
            } else {
                return this.compare(json, (Comparable)eval);
            }
            return false;
        }

        private boolean compare(JSONObject json, Comparable val) throws JSONException {
            if (val instanceof Number) {
                val = Double.valueOf(((Number)((Object)val)).doubleValue());
            }
            if (this.rhs == null) {
                return json.has(val.toString());
            }
            Comparable rhsVal = (Comparable)this.rhs.eval(json);
            int comparisonResult = val.compareTo(rhsVal);
            switch (this.ops) {
                case '>': {
                    return comparisonResult > 0;
                }
                case '=': {
                    return comparisonResult == 0;
                }
                case '<': {
                    return comparisonResult < 0;
                }
            }
            return false;
        }
    }

    public static interface Test {
        public boolean test(JSONObject var1) throws JSONException;
    }
}

