/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import com.is2t.tools.BitFieldHelper;
import com.is2t.tools.GeometryTools;
import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.microui.MicroUI;
import ej.microui.display.GraphicsContext;
import ej.microui.util.EventHandler;
import ej.mwt.Desktop;
import ej.mwt.Renderable;
import ej.mwt.RenderableHelper;
import ej.mwt.RepaintRenderable;
import ej.mwt.Widget;
import java.lang.ref.WeakReference;

public class Panel
implements Renderable {
    private static final int IS_VALIDATING_SHIFT = 0;
    private static final int IS_VALIDATING_MASK = 1;
    private static final int IS_VALID_SHIFT = 1;
    private static final int IS_VALID_MASK = 2;
    private static final int IS_PACKED_SHIFT = 2;
    private static final int IS_PACKED_MASK = 4;
    private static final int WAIT_VALIDATE_SHIFT = 3;
    private static final int WAIT_VALIDATE_MASK = 8;
    private byte flags;
    @NonNull
    private WeakReference<Widget> focusedWidget = new WeakReference<Object>(null);
    private short preferredWidth;
    private short preferredHeight;
    short x;
    short y;
    short width;
    short height;
    @Nullable
    private EventHandler eventHandler;
    @Nullable
    private Desktop desktop;
    @Nullable
    private Widget widget;

    public Panel() {
        this.setPacked(true);
    }

    public void setWidget(@Nullable Widget widget) throws IllegalArgumentException {
        if (this.widget != null) {
            this.widget.setPanel(null);
            this.setFocus(null);
        }
        if (widget != null) {
            if (widget.parent != null || widget.panel != null) {
                throw new IllegalArgumentException();
            }
            widget.setPanel(this);
        }
        this.widget = widget;
        this.invalidate();
        if (this.isShown()) {
            this.revalidate();
        }
    }

    @Nullable
    public Widget getWidget() {
        return this.widget;
    }

    public void setLocation(int x, int y) {
        this.setBounds(x, y, this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.setBounds(this.x, this.y, width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean resized = this.width != width || this.height != height;
        this.setBoundsInternal(x, y, width, height);
        if (resized) {
            this.invalidate();
        }
    }

    private void setBoundsInternal(int x, int y, int width, int height) {
        this.x = (short)x;
        this.y = (short)y;
        this.width = (short)width;
        this.height = (short)height;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    public void setPreferredSize(int preferredWidth, int preferredHeight) {
        this.preferredWidth = (short)preferredWidth;
        this.preferredHeight = (short)preferredHeight;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Deprecated
    public void show(Desktop desktop) throws NullPointerException {
        this.show(desktop, false);
    }

    @Deprecated
    public void show(Desktop desktop, boolean fill) throws NullPointerException {
        if (fill) {
            this.setPacked(false);
            this.setBounds(0, 0, desktop.getWidth(), desktop.getHeight());
        } else if (this.width == 0 || this.height == 0) {
            this.setPacked(true);
        }
        this.showInternal(desktop);
    }

    public void showFullScreen(@NonNull Desktop desktop) throws NullPointerException {
        this.setBounds(0, 0, desktop.getWidth(), desktop.getHeight());
        this.invalidate();
        this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)4);
        this.showInternal(desktop);
    }

    public void showAdjustingToChild(@NonNull Desktop desktop) throws NullPointerException {
        this.invalidate();
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)4);
        this.showInternal(desktop);
    }

    public void showUsingBounds(@NonNull Desktop desktop) throws NullPointerException {
        this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)4);
        this.showInternal(desktop);
    }

    protected void showInternal(@NonNull Desktop desktop) {
        Desktop previousDesktop = this.desktop;
        if (previousDesktop != desktop) {
            this.desktop = desktop;
            if (previousDesktop != null) {
                this.hideFromDesktop(previousDesktop);
                previousDesktop.repaint();
            }
            this.showToDesktop(desktop);
        }
        this.revalidate();
    }

    @Override
    public void showNotify() {
        if (this.widget != null) {
            this.widget.showNotify();
        }
    }

    @Override
    public void hideNotify() {
        if (this.widget != null) {
            this.widget.hideNotify();
        }
    }

    void showToDesktop(@NonNull Desktop desktop) {
        desktop.addPanel(this);
    }

    void hideFromDesktop(@NonNull Desktop desktop) {
        desktop.removePanel(this);
        this.detachFromDesktop();
    }

    void detachFromDesktop() {
        this.desktop = null;
    }

    public void hide() {
        Desktop desktop = this.desktop;
        if (desktop != null) {
            this.hideFromDesktop(desktop);
            desktop.repaint();
        }
    }

    @Override
    public boolean isShown() {
        Desktop desktop = this.desktop;
        return desktop != null && desktop.isShown();
    }

    public boolean isActive() {
        if (this.desktop != null) {
            return this.desktop.getActivePanel() == this;
        }
        return false;
    }

    public void becameActive() {
    }

    public void becameInactive() {
    }

    @Nullable
    public Desktop getDesktop() {
        return this.desktop;
    }

    @Override
    public void repaint() {
        this.repaintInternal(0, 0, this.width, this.height);
    }

    @Override
    public void repaint(int x, int y, int width, int height) {
        if (x < 0) {
            width += x;
            x = 0;
        }
        if (y < 0) {
            height += y;
            y = 0;
        }
        width = Math.min(this.width - x, width);
        height = Math.min(this.height - y, height);
        if (width <= 0 || height <= 0) {
            return;
        }
        this.repaintInternal(x, y, width, height);
    }

    @Override
    public void render(GraphicsContext g) {
    }

    public boolean isTransparent() {
        return true;
    }

    public boolean contains(int x, int y) {
        return GeometryTools.contains((int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)x, (int)y);
    }

    @Nullable
    public Widget getWidgetAt(int x, int y) {
        if (this.contains(x, y) && this.widget != null) {
            return this.widget.getWidgetAt(x - this.x, y - this.y);
        }
        return null;
    }

    public void setFocus(@Nullable Widget widget) throws IllegalArgumentException {
        Widget oldFocusedWidget;
        if (widget != null) {
            if (widget.panel != this) {
                throw new IllegalArgumentException();
            }
            if (!widget.isEnabled()) {
                return;
            }
        }
        if ((oldFocusedWidget = this.getFocusedWidget()) == widget) {
            return;
        }
        this.setFocusedWidget(widget);
        if (oldFocusedWidget != null) {
            try {
                oldFocusedWidget.lostFocus();
            }
            catch (Throwable e) {
                MicroUI.MicroUI.errorLog(e);
            }
        }
        if (widget != null) {
            try {
                widget.gainFocus();
            }
            catch (Throwable e) {
                MicroUI.MicroUI.errorLog(e);
            }
        }
    }

    public Widget getFocus() {
        return this.getFocusedWidget();
    }

    @Deprecated
    public void setPacked(boolean packed) {
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (boolean)packed, (int)4);
        this.invalidate();
    }

    @Deprecated
    public boolean isPacked() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)4);
    }

    public boolean isAdjustedToChild() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)4);
    }

    public void invalidate() {
        this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)2);
    }

    public boolean isValid() {
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)2);
    }

    public void revalidate() {
        Desktop desktop;
        if (!this.isValid() && !BitFieldHelper.getBooleanProperty((int)this.flags, (int)8) && (desktop = this.desktop) != null && desktop.isShown()) {
            this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)8);
            desktop.getDisplay().callSerially(new Runnable(){

                @Override
                public void run() {
                    Panel.this.validate();
                }
            });
        }
    }

    public void validate() {
        this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)8);
        if (!this.isValid()) {
            short heightHint;
            short widthHint;
            boolean pack = this.isPacked();
            this.startValidating();
            if (pack) {
                widthHint = 0;
                heightHint = 0;
            } else {
                widthHint = this.width;
                heightHint = this.height;
            }
            this.validate(widthHint, heightHint);
            if (pack) {
                this.setSize(this.preferredWidth, this.preferredHeight);
            }
            this.stopValidating();
            this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)2);
            Desktop desktop = this.desktop;
            if (desktop != null && !desktop.isValidating()) {
                this.repaint();
            }
        }
    }

    void startValidating() {
        this.flags = (byte)BitFieldHelper.setBooleanProperty((int)this.flags, (int)1);
    }

    void stopValidating() {
        this.flags = (byte)BitFieldHelper.unsetBooleanProperty((int)this.flags, (int)1);
    }

    public void validate(int widthHint, int heightHint) {
        Widget widget = this.widget;
        if (widget != null) {
            widget.validate(widthHint, heightHint);
            if (widthHint == 0) {
                widthHint = widget.getPreferredWidth();
            }
            if (heightHint == 0) {
                heightHint = widget.getPreferredHeight();
            }
            widget.setBounds(0, 0, widthHint, heightHint);
            this.preferredWidth = (short)widthHint;
            this.preferredHeight = (short)heightHint;
        }
    }

    @Override
    public void setEventHandler(@Nullable EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    @Nullable
    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public boolean handleEvent(int event) {
        return RenderableHelper.handleEvent(event, this.eventHandler) || this.handleDirection(event);
    }

    private boolean handleDirection(int event) {
        int direction;
        Widget widget = this.widget;
        if (widget != null && (direction = RenderableHelper.getDirection(event)) != 0) {
            return widget.requestFocus(direction);
        }
        return false;
    }

    @Nullable
    private Widget getFocusedWidget() {
        return (Widget)this.focusedWidget.get();
    }

    void setFocusedWidget(@Nullable Widget focusedWidget) {
        this.focusedWidget = new WeakReference<Widget>(focusedWidget);
    }

    boolean isValidating() {
        Desktop desktop = this.desktop;
        if (desktop != null && desktop.isValidating()) {
            return true;
        }
        return BitFieldHelper.getBooleanProperty((int)this.flags, (int)1);
    }

    void paint(@NonNull GraphicsContext g, int x, int y, int width, int height) {
        Desktop desktop = this.desktop;
        Widget widget = this.widget;
        this.beforePaint(g, x, y, width, height);
        int translateX = g.getTranslateX();
        int translateY = g.getTranslateY();
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        RenderableHelper.paintRenderable(g, desktop, this);
        if (widget != null) {
            widget.paint(g, translateX, translateY, clipX, clipY, clipWidth, clipHeight);
        }
    }

    void beforePaint(@NonNull GraphicsContext g, int x, int y, int width, int height) {
        g.reset();
        g.setSystemClip((int)this.x, (int)this.y, (int)this.width, (int)this.height);
        g.translate((int)this.x, (int)this.y);
        g.setClipAndUpdateSystemClip(x, y, width, height);
    }

    private void repaintInternal(int x, int y, int width, int height) {
        Desktop desktop = this.desktop;
        if (desktop != null && desktop.isShown()) {
            if (this.isTransparent()) {
                desktop.repaint(this.x + x, this.y + y, width, height);
            } else if (desktop.getActivePanel() == this) {
                desktop.getDisplay().callSerially((Runnable)new RepaintRenderable(desktop, x, y, width, height){

                    @Override
                    protected void paint(@NonNull GraphicsContext g) {
                        Panel.this.paint(g, this.x, this.y, this.width, this.height);
                    }
                });
            } else {
                desktop.repaintFrom(this, this.x + x, this.y + y, width, height);
            }
        }
    }
}

