/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.event;

import ej.fp.FrontPanel;
import ej.microui.event.LLUIInput;

public class EventPointer {
    public static final String COMMON_MICROUI_GENERATOR_TAG = "POINTER";
    private static final int BUTTONS_DRIVER_ACTION_MASK = 65280;
    private static final int BUTTONS_DRIVER_ACTION_SHIFT = 8;
    private static final int BUTTONS_DRIVER_BUTTON_MASK = 255;
    private static final int BUTTONS_DRIVER_BUTTON_SHIFT = 0;
    private static final int BUTTONS_DRIVER_PRESS = 0;
    private static final int BUTTONS_DRIVER_RELEASE = 1;
    private static final int POINTER_DRIVER_TYPE_SHIFT = 31;
    private static final int POINTER_DRIVER_TYPE_MASK = Integer.MIN_VALUE;
    private static final int POINTER_DRIVER_X_SHIFT = 16;
    private static final int POINTER_DRIVER_X_MASK = 0xFFF0000;
    private static final int POINTER_DRIVER_Y_SHIFT = 0;
    private static final int POINTER_DRIVER_Y_MASK = 4095;
    private static final int POINTER_DRIVER_TYPE_ABS = 0;
    private static final int POINTER_DRIVER_TYPE_DELTA = 1;
    private static final int POINTER_DRIVER_CMD_MOVE = 6;
    private static final int POINTER_DRIVER_CMD_PRESS = 0;
    private static final int POINTER_DRIVER_CMD_RELEASE = 1;

    private EventPointer() {
    }

    public static void sendPressedEvent(int buttonId, int x, int y, boolean absolute) {
        EventPointer.sendPressedEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId, x, y, absolute);
    }

    public static void sendPressedEvent(String pointerEventGenerator, int buttonId, int x, int y, boolean absolute) {
        try {
            EventPointer.sendEvents(pointerEventGenerator, 0, x, y, absolute, buttonId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder buf = new StringBuilder();
            buf.append("press button ");
            buf.append(buttonId);
            buf.append(" at ");
            buf.append(x);
            buf.append(",");
            buf.append(y);
            EventPointer.traceEvent(pointerEventGenerator, buf.toString());
        }
    }

    public static void sendReleasedEvent(int buttonId) {
        EventPointer.sendReleasedEvent(COMMON_MICROUI_GENERATOR_TAG, buttonId);
    }

    public static void sendReleasedEvent(String pointerEventGenerator, int buttonId) {
        try {
            EventPointer.sendEvents(pointerEventGenerator, 1, 0, 0, false, buttonId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            EventPointer.traceEvent(pointerEventGenerator, "release button " + buttonId);
        }
    }

    public static void sendMovedEvent(int x, int y, boolean absolute) {
        EventPointer.sendMovedEvent(COMMON_MICROUI_GENERATOR_TAG, x, y, absolute);
    }

    public static void sendMovedEvent(String pointerEventGenerator, int x, int y, boolean absolute) {
        try {
            EventPointer.sendEvents(pointerEventGenerator, 6, x, y, absolute, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuilder buf = new StringBuilder();
            buf.append("move at ");
            buf.append(x);
            buf.append(",");
            buf.append(y);
            EventPointer.traceEvent(pointerEventGenerator, buf.toString());
        }
    }

    private static void sendEvents(String eventGen, int cmd, int x, int y, boolean abs, int button) {
        int event = cmd << 8 & 0xFF00 | button << 0 & 0xFF;
        int data = (abs ? 0 : 1) << 31 & Integer.MIN_VALUE | x << 16 & 0xFFF0000 | y << 0 & 0xFFF;
        int[] events = new int[]{LLUIInput.buildEvent(eventGen, event), data};
        LLUIInput.sendEvents(events);
    }

    private static void traceEvent(String pointerEventGenerator, String desc) {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(EventPointer.class.getName());
        buf.append("] ");
        buf.append(desc);
        buf.append(" (");
        buf.append(pointerEventGenerator);
        buf.append(")");
        FrontPanel.out.println(buf.toString());
    }
}

