/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import ej.annotation.Nullable;
import java.time.DateTimeException;
import java.time.chrono.Era;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;

public enum IsoEra implements Era
{
    BCE,
    CE;


    public static IsoEra of(int isoEra) {
        switch (isoEra) {
            case 0: {
                return BCE;
            }
            case 1: {
                return CE;
            }
        }
        throw new DateTimeException("Invalid era: " + isoEra);
    }

    @Override
    public int getValue() {
        return this.ordinal();
    }

    @Override
    public boolean isSupported(@Nullable TemporalField field) {
        if (field instanceof ChronoField) {
            return field == ChronoField.ERA;
        }
        return field != null && field.isSupportedBy(this);
    }

    @Override
    public ValueRange range(TemporalField field) {
        if (field instanceof ChronoField) {
            if (this.isSupported(field)) {
                return field.range();
            }
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.rangeRefinedBy(this);
    }

    @Override
    public int get(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        ValueRange range = this.range(field);
        if (!range.isIntValue()) {
            throw new UnsupportedTemporalTypeException("Invalid field " + field + " for get() method, use getLong() instead");
        }
        long value = this.getLong(field);
        if (!range.isValidValue(value)) {
            throw new DateTimeException("Invalid value for " + field + " (valid values " + range + "): " + value);
        }
        return (int)value;
    }

    @Override
    public long getLong(TemporalField field) {
        if (field == ChronoField.ERA) {
            return this.getValue();
        }
        if (field instanceof ChronoField) {
            throw new UnsupportedTemporalTypeException("Unsupported field: " + field);
        }
        return field.getFrom(this);
    }

    @Override
    @Nullable
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.precision()) {
            return (R)ChronoUnit.ERAS;
        }
        if (query == TemporalQueries.zoneId() || query == TemporalQueries.chronology()) {
            return null;
        }
        return query.queryFrom(this);
    }

    @Override
    public Temporal adjustInto(Temporal temporal) {
        return temporal.with(ChronoField.ERA, this.getValue());
    }
}

