/*
 * Decompiled with CFR 0.152.
 */
package ej.microui.display;

import ej.microui.Log;
import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIFont;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microui.display.MicroUIImage;
import ej.microui.display.MicroUIRenderableString;
import ej.microui.display.Rectangle;

public class LLUIPainter {
    public static final int DRAWING_SUCCESS = 0;
    public static final int DRAWING_LOG_ERROR = Integer.MIN_VALUE;
    public static final int DRAWING_LOG_NOT_IMPLEMENTED = 1;
    public static final int DRAWING_LOG_FORBIDDEN = 2;
    public static final int DRAWING_LOG_OUT_OF_MEMORY = 4;
    public static final int DRAWING_LOG_CLIP_MODIFIED = 8;
    public static final int DRAWING_LOG_MISSING_CHARACTER = 16;
    public static final int DRAWING_LOG_LIBRARY_INCIDENT = 0x20000000;
    public static final int DRAWING_LOG_UNKNOWN_INCIDENT = 0x40000000;

    private LLUIPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePixel(byte[] target, int x, int y) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(80, Log.mapGraphicsContext(gc), x, y);
                if (gc.isPointInClip(x, y)) {
                    gc.configureClip(false);
                    LLUIDisplay.Instance.getUIDrawer(gc).writePixel(gc, x, y);
                } else {
                    LLUIPainter.logOutOfClip(gc);
                }
                Log.recordEventEnd(80, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLine(byte[] target, int x1, int y1, int x2, int y2) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(81, Log.mapGraphicsContext(gc), x1, y1, x2, y2);
                LLUIDisplay.Instance.getUIDrawer(gc).drawLine(gc, x1, y1, x2, y2);
                Log.recordEventEnd(81, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawHorizontalLine(byte[] target, int x, int y, int width) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(82, Log.mapGraphicsContext(gc), x, y, width);
                if (width > 0) {
                    Rectangle region = LLUIPainter.cropDrawnRegionToClip(gc, x, y, x + width - 1, y);
                    if (region != null) {
                        gc.configureClip(false);
                        LLUIPainter.logDrawnRegion(gc, region);
                        LLUIDisplay.Instance.getUIDrawer(gc).drawHorizontalLine(gc, region.getX1(), region.getX2(), region.getY1());
                    } else {
                        LLUIPainter.logOutOfClip(gc);
                    }
                }
                Log.recordEventEnd(82, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawVerticalLine(byte[] target, int x, int y, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(83, Log.mapGraphicsContext(gc), x, y, height);
                Rectangle region = LLUIPainter.cropDrawnRegionToClip(gc, x, y, x, y + height - 1);
                if (region != null) {
                    gc.configureClip(false);
                    LLUIPainter.logDrawnRegion(gc, region);
                    LLUIDisplay.Instance.getUIDrawer(gc).drawVerticalLine(gc, region.getX1(), region.getY1(), region.getY2());
                } else {
                    LLUIPainter.logOutOfClip(gc);
                }
                Log.recordEventEnd(83, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangle(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(84, Log.mapGraphicsContext(gc), x, y, width, height);
                if (width > 0 && height > 0) {
                    int x1 = x;
                    int y1 = y;
                    int x2 = x + width - 1;
                    int y2 = y + height - 1;
                    gc.configureClip(!gc.isRectangleInClip(x1, y1, x2, y2));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawRectangle(gc, x1, y1, x2, y2);
                }
                Log.recordEventEnd(84, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRectangle(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(85, Log.mapGraphicsContext(gc), x, y, width, height);
                if (width > 0 && height > 0) {
                    Rectangle region = LLUIPainter.cropDrawnRegionToClip(gc, x, y, x + width - 1, y + height - 1);
                    if (region != null) {
                        gc.configureClip(false);
                        LLUIPainter.logDrawnRegion(gc, region);
                        LLUIDisplay.Instance.getUIDrawer(gc).fillRectangle(gc, region.getX1(), region.getY1(), region.getX2(), region.getY2());
                    } else {
                        LLUIPainter.logOutOfClip(gc);
                    }
                }
                Log.recordEventEnd(85, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRoundedRectangle(byte[] target, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(86, Log.mapGraphicsContext(gc), x, y, width, height, arcWidth, arcHeight);
                if (width > 0 && height > 0) {
                    gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
                }
                Log.recordEventEnd(86, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillRoundedRectangle(byte[] target, int x, int y, int width, int height, int arcWidth, int arcHeight) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(87, Log.mapGraphicsContext(gc), x, y, width, height, arcWidth, arcHeight);
                if (width > 0 && height > 0) {
                    Rectangle region = LLUIPainter.cropDrawnRegionToClip(gc, x, y, x + width - 1, y + height - 1);
                    if (region != null) {
                        gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                        LLUIPainter.logDrawnRegion(gc, region);
                        LLUIDisplay.Instance.getUIDrawer(gc).fillRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
                    } else {
                        LLUIPainter.logOutOfClip(gc);
                    }
                }
                Log.recordEventEnd(87, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(88, Log.mapGraphicsContext(gc), x, y, diameter, (int)startAngle, (int)arcAngle);
                if (diameter > 0 && arcAngle != 0.0f) {
                    gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawCircleArc(gc, x, y, diameter, startAngle, arcAngle);
                }
                Log.recordEventEnd(88, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipseArc(byte[] target, int x, int y, int width, int height, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(90, Log.mapGraphicsContext(gc), x, y, width, height, (int)startAngle, (int)arcAngle);
                if (width > 0 && height > 0 && arcAngle != 0.0f) {
                    gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
                }
                Log.recordEventEnd(90, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircleArc(byte[] target, int x, int y, int diameter, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(89, Log.mapGraphicsContext(gc), x, y, diameter, (int)startAngle, (int)arcAngle);
                if (diameter > 0 && arcAngle != 0.0f) {
                    gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                    LLUIDisplay.Instance.getUIDrawer(gc).fillCircleArc(gc, x, y, diameter, startAngle, arcAngle);
                }
                Log.recordEventEnd(89, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipseArc(byte[] target, int x, int y, int width, int height, float startAngle, float arcAngle) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(91, Log.mapGraphicsContext(gc), x, y, width, height, (int)startAngle, (int)arcAngle);
                if (width > 0 && height > 0 && arcAngle != 0.0f) {
                    gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                    LLUIDisplay.Instance.getUIDrawer(gc).fillEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
                }
                Log.recordEventEnd(91, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEllipse(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(92, Log.mapGraphicsContext(gc), x, y, width, height);
                if (width > 0 && height > 0) {
                    gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawEllipse(gc, x, y, width, height);
                }
                Log.recordEventEnd(92, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillEllipse(byte[] target, int x, int y, int width, int height) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(93, Log.mapGraphicsContext(gc), x, y, width, height);
                if (width > 0 && height > 0) {
                    gc.configureClip(!gc.isRegionInClip(x, y, width, height));
                    LLUIDisplay.Instance.getUIDrawer(gc).fillEllipse(gc, x, y, width, height);
                }
                Log.recordEventEnd(93, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawCircle(byte[] target, int x, int y, int diameter) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(94, Log.mapGraphicsContext(gc), x, y, diameter);
                if (diameter > 0) {
                    gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                    LLUIDisplay.Instance.getUIDrawer(gc).drawCircle(gc, x, y, diameter);
                }
                Log.recordEventEnd(94, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillCircle(byte[] target, int x, int y, int diameter) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                Log.recordEvent(95, Log.mapGraphicsContext(gc), x, y, diameter);
                if (diameter > 0) {
                    gc.configureClip(!gc.isRegionInClip(x, y, diameter, diameter));
                    LLUIDisplay.Instance.getUIDrawer(gc).fillCircle(gc, x, y, diameter);
                }
                Log.recordEventEnd(95, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImage(byte[] target, byte[] source, int regionX, int regionY, int width, int height, int x, int y, int alpha) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            if (gc.requestDrawing()) {
                MicroUIImage image = graphicsEngine.mapMicroUIImage(source);
                Log.recordEvent(96, Log.mapGraphicsContext(gc), Log.mapImage(image), regionX, regionY, width, height, x, y, alpha);
                if (!image.isClosed() && alpha > 0) {
                    Rectangle region = new Rectangle(regionX, regionY, regionX + width - 1, regionY + height - 1);
                    image = graphicsEngine.getSource(image);
                    Rectangle dest = LLUIPainter.cropRegionAndDestinationToBounds(image, region, x, y);
                    region = LLUIPainter.cropRegionAndDestinationToBounds(gc, dest, region.getX1(), region.getY1());
                    Rectangle clippedRegion = LLUIPainter.cropDrawnRegionToClip(gc, dest);
                    if (clippedRegion != null) {
                        gc.configureClip(false);
                        LLUIPainter.logDrawnRegion(gc, clippedRegion);
                        LLUIDisplay.Instance.getUIDrawer(gc).drawImage(gc, image, region.getX1() + (clippedRegion.getX1() - dest.getX1()), region.getY1() + (clippedRegion.getY1() - dest.getY1()), clippedRegion.getWidth(), clippedRegion.getHeight(), clippedRegion.getX1(), clippedRegion.getY1(), alpha);
                    } else {
                        LLUIPainter.logOutOfClip(gc);
                    }
                }
                Log.recordEventEnd(96, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawString(byte[] target, char[] chars, int offset, int length, byte[] fontData, int x, int y) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
            char[] string = graphicsEngine.mapString(chars, offset, length);
            if (gc.requestDrawing()) {
                Log.recordEvent(97, Log.mapGraphicsContext(gc), length, x, y);
                if (length > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawString(gc, string, font, x, y);
                }
                Log.recordEventEnd(97, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int stringWidth(char[] chars, int offset, int length, byte[] fontData) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            Log.recordEvent(62, length);
            if (length > 0) {
                MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
                char[] string = graphicsEngine.mapString(chars, offset, length);
                return LLUIDisplay.Instance.getUIFontDrawer(font).stringWidth(string, font);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRenderableString(byte[] target, char[] chars, int offset, int length, byte[] fontData, int charsWidth, byte[] renderableStringSNIContext, int x, int y) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIGraphicsContext gc = graphicsEngine.mapMicroUIGraphicsContext(target);
            MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
            char[] string = graphicsEngine.mapString(chars, offset, length);
            MicroUIRenderableString renderableString = graphicsEngine.mapMicroUIRenderableString(renderableStringSNIContext);
            if (gc.requestDrawing()) {
                Log.recordEvent(97, Log.mapGraphicsContext(gc), length, x, y);
                if (length > 0) {
                    LLUIDisplay.Instance.getUIDrawer(gc).drawRenderableString(gc, string, font, charsWidth, renderableString, x, y);
                }
                Log.recordEventEnd(97, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int initializeRenderableStringSNIContext(char[] chars, int offset, int length, byte[] fontData, byte[] renderableStringSNIContext) {
        LLUIDisplay graphicsEngine;
        LLUIDisplay lLUIDisplay = graphicsEngine = LLUIDisplay.Instance;
        synchronized (lLUIDisplay) {
            MicroUIFont font = graphicsEngine.mapMicroUIFont(fontData);
            char[] string = graphicsEngine.mapString(chars, offset, length);
            MicroUIRenderableString renderableString = graphicsEngine.mapMicroUIRenderableString(renderableStringSNIContext);
            return LLUIDisplay.Instance.getUIFontDrawer(font).initializeRenderableStringSNIContext(string, font, renderableString);
        }
    }

    private static Rectangle cropDrawnRegionToClip(MicroUIGraphicsContext gc, Rectangle region) {
        return LLUIPainter.cropDrawnRegionToClip(gc, region.getX1(), region.getY1(), region.getX2(), region.getY2());
    }

    private static Rectangle cropDrawnRegionToClip(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
        x1 = Math.max(x1, gc.getClipX1());
        y1 = Math.max(y1, gc.getClipY1());
        x2 = Math.min(x2, gc.getClipX2());
        y2 = Math.min(y2, gc.getClipY2());
        return x2 >= x1 && y2 >= y1 ? new Rectangle(x1, y1, x2, y2) : null;
    }

    private static Rectangle cropRegionAndDestinationToBounds(MicroUIImage bounds, Rectangle source, int destX, int destY) {
        int srcX = source.getX1();
        int srcY = source.getY1();
        int width = source.getWidth();
        int height = source.getHeight();
        if (srcX < 0) {
            width += srcX;
            destX -= srcX;
            srcX = 0;
        }
        if (srcX + width > bounds.getWidth()) {
            width = bounds.getWidth() - srcX;
        }
        if (srcY < 0) {
            height += srcY;
            destY -= srcY;
            srcY = 0;
        }
        if (srcY + height > bounds.getHeight()) {
            height = bounds.getHeight() - srcY;
        }
        source.setX1(srcX);
        source.setY1(srcY);
        source.setX2(srcX + width - 1);
        source.setY2(srcY + height - 1);
        return new Rectangle(destX, destY, destX + width - 1, destY + height - 1);
    }

    public static void logDrawnRegion(MicroUIGraphicsContext gc, Rectangle rect) {
        LLUIPainter.logDrawnRegion(gc, rect.getX1(), rect.getY1(), rect.getWidth(), rect.getHeight());
    }

    public static void logDrawnRegion(MicroUIGraphicsContext gc, int x, int y, int w, int h) {
        Log.recordEvent(68, Log.mapGraphicsContext(gc), Log.mapBoolean(!gc.isClipEnabled()), x, y, w, h);
    }

    public static void logOutOfClip(MicroUIGraphicsContext gc) {
        Log.recordEvent(67, Log.mapGraphicsContext(gc));
    }
}

