/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.annotation.Nullable;
import ej.hoka.http.requesthandler.RequestHandler;

public class Route {
    static final String DEFAULT_ACCEPT_TYPE = "*/*";
    private final int httpMethod;
    private final String path;
    @Nullable
    private final String acceptType;
    private final RequestHandler handler;

    public Route(int httpMethod, String path, RequestHandler handler) {
        this(httpMethod, path, null, handler);
    }

    public Route(int httpMethod, String path, @Nullable String acceptType, RequestHandler handler) {
        this.handler = handler;
        this.httpMethod = httpMethod;
        this.acceptType = acceptType == null ? null : acceptType.trim().toLowerCase();
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public int getHttpMethod() {
        return this.httpMethod;
    }

    @Nullable
    public String getAcceptType() {
        return this.acceptType;
    }

    public RequestHandler getHandler() {
        return this.handler;
    }

    public boolean acceptAllContentTypes() {
        return this.acceptType == null || DEFAULT_ACCEPT_TYPE.equals(this.acceptType);
    }

    public String getHttpMethodAsString() {
        switch (this.httpMethod) {
            case 10: {
                return "BEFORE_ALL";
            }
            case 11: {
                return "BEFORE";
            }
            case 12: {
                return "AFTER";
            }
            case 13: {
                return "AFTER_ALL";
            }
            case 2: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
            case 3: {
                return "PUT";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "HEAD";
            }
            case 6: {
                return "CONNECT";
            }
            case 7: {
                return "OPTIONS";
            }
            case 8: {
                return "TRACE";
            }
            case 9: {
                return "PATCH";
            }
        }
        throw new IllegalArgumentException("Http method not supported");
    }

    public int hashCode() {
        int result = 1;
        String acceptType = this.acceptType;
        result = 31 * result + (acceptType == null ? 0 : acceptType.hashCode());
        result = 31 * result + this.httpMethod;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Route other = (Route)obj;
        String acceptType = this.acceptType;
        if (acceptType == null ? other.acceptType != null : !acceptType.equals(other.acceptType)) {
            return false;
        }
        if (this.httpMethod != other.httpMethod) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

