/*
 * Decompiled with CFR 0.152.
 */
package ej.junit;

import ej.junit.TestListener;
import ej.junit.TestWrapper;

public abstract class AbstractTestWrapper
implements TestWrapper {
    protected final Class<?> testClass;
    protected final String testClassName;
    protected boolean failed = false;
    protected String testMethod;
    protected long testMethodStart;
    protected Object test;
    int runs;
    int failures;
    int errors;
    protected TestListener testListener;

    public AbstractTestWrapper(Class<?> testClass) {
        this.testClass = testClass;
        this.testClassName = testClass.getName();
    }

    protected void reportError(Throwable error) {
        long duration = System.currentTimeMillis() - this.testMethodStart;
        ++this.errors;
        if (this.testListener != null) {
            this.testListener.testError(this.testClassName, this.testMethod, duration, error, error.getMessage());
        }
    }

    protected void reportFailure(AssertionError error) {
        long duration = System.currentTimeMillis() - this.testMethodStart;
        ++this.failures;
        if (this.testListener != null) {
            this.testListener.testFailure(this.testClassName, this.testMethod, duration, (Throwable)((Object)error), ((Throwable)((Object)error)).getMessage());
        }
    }

    protected void reportSuccess() {
        long duration = System.currentTimeMillis() - this.testMethodStart;
        if (this.testListener != null) {
            this.testListener.testSuccess(this.testClassName, this.testMethod, duration);
        }
    }

    protected abstract void runBeforeClassMethods() throws Exception;

    protected abstract void runAfterClassMethods() throws Exception;

    protected abstract void runBeforeMethods() throws Exception;

    protected abstract void runAfterMethods() throws Exception;

    protected abstract void runTestMethods();

    boolean wrapperRunBeforeClassMethod() {
        try {
            this.testMethod = null;
            this.testMethodStart = System.currentTimeMillis();
            this.runBeforeClassMethods();
            return true;
        }
        catch (Throwable t) {
            this.reportError(t);
            return false;
        }
    }

    void wrapperRunAfterClassMethod() {
        try {
            this.testMethod = null;
            this.testMethodStart = System.currentTimeMillis();
            this.runAfterClassMethods();
        }
        catch (Throwable t) {
            this.reportError(t);
        }
    }

    protected final boolean testInitialize(String testMethodName) {
        try {
            ++this.runs;
            if (this.testListener != null) {
                this.testListener.testInstance(this.testClass.getName());
            }
            this.test = this.testClass.newInstance();
            this.testMethod = testMethodName;
            this.runBeforeMethods();
            if (this.testListener != null) {
                this.testListener.testStarted(this.testClass.getName(), testMethodName);
            }
            return true;
        }
        catch (Throwable t) {
            this.reportError(t);
            return false;
        }
    }

    protected final void testFinalize(boolean success) {
        try {
            try {
                if (this.test != null) {
                    this.runAfterMethods();
                }
            }
            catch (Throwable t) {
                this.reportError(t);
                if (this.test != null && success) {
                    this.reportSuccess();
                }
                this.testMethod = null;
            }
        }
        finally {
            if (this.test != null && success) {
                this.reportSuccess();
            }
            this.testMethod = null;
        }
    }

    private synchronized void wrapperRunTestMethods() {
        try {
            try {
                boolean ok = this.wrapperRunBeforeClassMethod();
                if (ok) {
                    this.runTestMethods();
                }
            }
            finally {
                this.wrapperRunAfterClassMethod();
            }
        }
        catch (Throwable t) {
            this.reportError(t);
        }
    }

    @Override
    public String getTestClass() {
        return this.testClassName;
    }

    @Override
    public synchronized boolean run(TestListener listener) {
        this.failures = 0;
        this.errors = 0;
        this.testListener = listener;
        if (this.testListener != null) {
            this.testListener.testSuiteStarted(this.testClassName);
        }
        this.wrapperRunTestMethods();
        if (this.testListener != null) {
            this.testListener.testSuiteEnded(this.testClassName, this.runs, this.failures, this.errors);
        }
        return this.errors == 0 && this.failures == 0;
    }
}

