/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.outline.border;

import ej.annotation.Nullable;
import ej.microui.display.GraphicsContext;
import ej.mwt.style.outline.FlexibleOutline;
import ej.mwt.style.outline.border.BorderHelper;
import ej.mwt.util.Size;

public class FlexibleRectangularBorder
extends FlexibleOutline {
    private final int color;

    public FlexibleRectangularBorder(int color, int top, int right, int bottom, int left) {
        super(top, right, bottom, left);
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    @Override
    public void apply(GraphicsContext g, Size size) {
        int width = size.getWidth();
        int height = size.getHeight();
        int top = this.getTop();
        int bottom = this.getBottom();
        int left = this.getLeft();
        int right = this.getRight();
        g.setColor(this.color);
        BorderHelper.drawRectangularBorder(g, width, height, left, top, right, bottom);
        super.apply(g, size);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof FlexibleRectangularBorder) {
            FlexibleRectangularBorder border = (FlexibleRectangularBorder)obj;
            return this.color == border.color && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 15 * this.color + super.hashCode();
    }
}

