/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt.style.dimension;

import ej.annotation.Nullable;
import ej.bon.XMath;
import ej.mwt.Widget;
import ej.mwt.style.Style;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.dimension.DimensionHelper;
import ej.mwt.util.OutlineHelper;
import ej.mwt.util.Rectangle;
import ej.mwt.util.Size;

public class FixedDimension
implements Dimension {
    private final char width;
    private final char height;

    public FixedDimension(int width, int height) {
        this.width = (char)XMath.limit((int)width, (int)0, (int)65535);
        this.height = (char)XMath.limit((int)height, (int)0, (int)65535);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void getAvailableSize(Widget widget, int availableWidth, int availableHeight, Size availableSize) {
        if (this.width != '\u0000') {
            availableSize.setWidth(this.width);
        }
        if (this.height != '\u0000') {
            availableSize.setHeight(this.height);
        }
    }

    @Override
    public void computeOptimalSize(Widget widget, int availableWidth, int availableHeight, Size optimalSize) {
        if (this.width != '\u0000') {
            optimalSize.setWidth(this.width);
        }
        if (this.height != '\u0000') {
            optimalSize.setHeight(this.height);
        }
    }

    @Override
    public void layOut(Widget widget, Rectangle bounds) {
        Style style = widget.getStyle();
        int leftOutlines = -bounds.getX();
        int topOutlines = -bounds.getY();
        int rightOutlines = bounds.getWidth();
        int bottomOutlines = bounds.getHeight();
        OutlineHelper.applyOutlines(bounds, style);
        DimensionHelper.layOut(widget, bounds, this.width != '\u0000', this.height != '\u0000', this.width, this.height);
        bounds.addOutline(leftOutlines, topOutlines, rightOutlines -= bounds.getWidth() + (leftOutlines += bounds.getX()), bottomOutlines -= bounds.getHeight() + (topOutlines += bounds.getY()));
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj instanceof FixedDimension) {
            FixedDimension dimension = (FixedDimension)obj;
            return this.width == dimension.width && this.height == dimension.height;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 3 * this.width + 5 * this.height;
    }
}

