/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.debug;

import ej.microui.display.Font;
import ej.mwt.style.background.Background;
import ej.mwt.style.background.RoundedBackground;
import ej.mwt.style.dimension.Dimension;
import ej.mwt.style.dimension.FixedDimension;
import ej.mwt.style.dimension.OptimalDimension;
import ej.mwt.style.dimension.RelativeDimension;
import ej.mwt.style.outline.Outline;
import ej.mwt.style.outline.border.RoundedBorder;
import ej.mwt.stylesheet.selector.ClassSelector;
import ej.mwt.stylesheet.selector.DisabledSelector;
import ej.mwt.stylesheet.selector.EnabledSelector;
import ej.mwt.stylesheet.selector.EvenChildSelector;
import ej.mwt.stylesheet.selector.FirstChildSelector;
import ej.mwt.stylesheet.selector.LastChildSelector;
import ej.mwt.stylesheet.selector.NotSelector;
import ej.mwt.stylesheet.selector.NthChildSelector;
import ej.mwt.stylesheet.selector.OddChildSelector;
import ej.mwt.stylesheet.selector.RootSelector;
import ej.mwt.stylesheet.selector.Selector;
import ej.mwt.stylesheet.selector.StateSelector;
import ej.mwt.stylesheet.selector.StrictTypeSelector;
import ej.mwt.stylesheet.selector.TypeSelector;
import ej.mwt.stylesheet.selector.UniversalSelector;
import ej.mwt.stylesheet.selector.combinator.AdjacentSiblingCombinator;
import ej.mwt.stylesheet.selector.combinator.AndCombinator;
import ej.mwt.stylesheet.selector.combinator.ChildCombinator;
import ej.mwt.stylesheet.selector.combinator.Combinator;
import ej.mwt.stylesheet.selector.combinator.DescendantCombinator;
import ej.mwt.stylesheet.selector.combinator.GeneralSiblingCombinator;

class Stringifier {
    private Stringifier() {
    }

    public static String toString(Dimension dimension) {
        String string = dimension instanceof FixedDimension ? Stringifier.toString((FixedDimension)dimension) : (dimension instanceof OptimalDimension ? Stringifier.toString((OptimalDimension)dimension) : (dimension instanceof RelativeDimension ? Stringifier.toString((RelativeDimension)dimension) : Stringifier.getClassName(dimension)));
        return string;
    }

    public static String colorToString(int color) {
        switch (color) {
            case 0: {
                return "black";
            }
            case 255: {
                return "blue";
            }
            case 65535: {
                return "cyan";
            }
            case 0x808080: {
                return "gray";
            }
            case 32768: {
                return "green";
            }
            case 65280: {
                return "lime";
            }
            case 0xFF00FF: {
                return "magenta";
            }
            case 0x800000: {
                return "maroon";
            }
            case 128: {
                return "navy";
            }
            case 0x808000: {
                return "olive";
            }
            case 0x800080: {
                return "purple";
            }
            case 0xFF0000: {
                return "red";
            }
            case 0xC0C0C0: {
                return "silver";
            }
            case 32896: {
                return "teal";
            }
            case 0xFFFFFF: {
                return "white";
            }
            case 0xFFFF00: {
                return "yellow";
            }
        }
        String hex = Integer.toHexString(color);
        char[] chars = new char[7];
        chars[0] = 35;
        int i = 1;
        int n = hex.length();
        int len = chars.length;
        while (i < len) {
            int j = i + n - len;
            chars[i] = j < 0 ? 48 : (int)hex.charAt(j);
            ++i;
        }
        return new String(chars);
    }

    public static String toString(Outline border) {
        String string = border instanceof RoundedBorder ? Stringifier.toString((RoundedBorder)border) : Stringifier.getClassName(border);
        return string;
    }

    public static String toString(Background background) {
        String string = background instanceof RoundedBackground ? Stringifier.toString((RoundedBackground)background) : Stringifier.getClassName(background);
        return string;
    }

    public static String toString(Font font) {
        String string = Stringifier.getClassName(font);
        String descriptor = font.getDescriptor();
        if (!descriptor.isEmpty()) {
            string = String.valueOf(string) + "[" + descriptor + "]";
        }
        return string;
    }

    public static String alignmentToString(int alignment) {
        switch (alignment) {
            case 5: {
                return "bottom";
            }
            case 1: {
                return "hcenter";
            }
            case 0: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "top";
            }
            case 4: {
                return "vcenter";
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getClassName(Object object) {
        return Stringifier.getClassName(object.getClass());
    }

    private static String getClassName(Class<?> clazz) {
        int length;
        String simpleName = clazz.getSimpleName();
        if (simpleName.charAt((length = simpleName.length()) - 1) == '@' && simpleName.charAt(0) != '@') {
            simpleName = simpleName.substring(0, length - 1);
        }
        return simpleName;
    }

    private static String toString(RoundedBackground roundedBackground) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(RoundedBackground.class));
        stringBuilder.append("[color=").append(Stringifier.colorToString(roundedBackground.getColor()));
        stringBuilder.append(", radius=").append(roundedBackground.getCornerRadius());
        stringBuilder.append(", thickness=").append(roundedBackground.getBorderThickness());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static String toString(RoundedBorder roundedBorder) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(RoundedBorder.class));
        stringBuilder.append("[color=").append(Stringifier.colorToString(roundedBorder.getColor()));
        stringBuilder.append(", radius=").append(roundedBorder.getCornerRadius());
        stringBuilder.append(", thickness=").append(roundedBorder.getThickness());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(FixedDimension dimension) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(FixedDimension.class));
        stringBuilder.append("[width=").append(dimension.getWidth());
        stringBuilder.append(", height=").append(dimension.getHeight());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(OptimalDimension dimension) {
        String type = dimension == OptimalDimension.OPTIMAL_DIMENSION_X ? "X" : (dimension == OptimalDimension.OPTIMAL_DIMENSION_Y ? "Y" : (dimension == OptimalDimension.OPTIMAL_DIMENSION_XY ? "XY" : "unknown"));
        return String.valueOf(Stringifier.getClassName(OptimalDimension.class)) + "[" + type + "]";
    }

    public static String toString(RelativeDimension dimension) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Stringifier.getClassName(FixedDimension.class));
        stringBuilder.append("[widthRatio=").append(dimension.getWidthRatio());
        stringBuilder.append(", heightRatio=").append(dimension.getHeightRatio());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(Selector selector) {
        StringBuilder stringBuilder = new StringBuilder();
        if (selector instanceof ClassSelector) {
            stringBuilder.append(".class ").append(((ClassSelector)selector).getClassName());
        } else if (selector instanceof DisabledSelector) {
            stringBuilder.append(":disabled");
        } else if (selector instanceof EnabledSelector) {
            stringBuilder.append(":enabled");
        } else if (selector instanceof EvenChildSelector) {
            stringBuilder.append(":nth-child(even)");
        } else if (selector instanceof FirstChildSelector) {
            stringBuilder.append(":first-child");
        } else if (selector instanceof LastChildSelector) {
            stringBuilder.append(":last-child");
        } else if (selector instanceof NotSelector) {
            stringBuilder.append(":not()");
        } else if (selector instanceof NthChildSelector) {
            stringBuilder.append(":nth-child(").append(((NthChildSelector)selector).getIndex()).append(')');
        } else if (selector instanceof OddChildSelector) {
            stringBuilder.append(":nth-child(odd)");
        } else if (selector instanceof RootSelector) {
            stringBuilder.append(":root");
        } else if (selector instanceof StateSelector) {
            stringBuilder.append(":state ").append(((StateSelector)selector).getState());
        } else if (selector instanceof StrictTypeSelector) {
            stringBuilder.append("type ").append(((StrictTypeSelector)selector).getType().getName());
        } else if (selector instanceof TypeSelector) {
            stringBuilder.append("type ").append(((TypeSelector)selector).getType().getName());
        } else if (selector instanceof UniversalSelector) {
            stringBuilder.append("*");
        } else if (selector instanceof Combinator) {
            stringBuilder.append(Stringifier.toString((Combinator)selector));
        } else {
            stringBuilder.append(selector.toString());
        }
        return stringBuilder.toString();
    }

    public static String toString(Combinator combinator) {
        String separator = combinator instanceof AdjacentSiblingCombinator ? " + " : (combinator instanceof AndCombinator ? " and " : (combinator instanceof ChildCombinator ? " > " : (combinator instanceof DescendantCombinator ? " " : (combinator instanceof GeneralSiblingCombinator ? " ~ " : combinator.getClass().getName()))));
        return String.valueOf(Stringifier.toString(combinator.getFirstSelector())) + separator + Stringifier.toString(combinator.getSecondSelector());
    }
}

