/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.color;

import ej.widget.color.ColorHelper;

public class LightHelper {
    private static final int LIGHT_COLOR_LIMIT = 127;
    private static final float BLUE_LIGHT_FACTOR = 0.114f;
    private static final float GREEN_LIGHT_FACTOR = 0.587f;
    private static final float RED_LIGHT_FACTOR = 0.299f;
    private static final int LIGHT_FACTOR = 16;

    private LightHelper() {
    }

    public static int getDarkestColor(int color1, int color2) {
        int result = color1;
        if (LightHelper.getLight(color2) < LightHelper.getLight(color1)) {
            result = color2;
        }
        return result;
    }

    public static int getLightestColor(int color1, int color2) {
        int result = color1;
        if (LightHelper.getLight(color2) > LightHelper.getLight(color1)) {
            result = color2;
        }
        return result;
    }

    public static int darkenColor(int color, int factor) {
        return LightHelper.modifyColorLight(color, -factor);
    }

    public static int lightenColor(int color, int factor) {
        return LightHelper.modifyColorLight(color, factor);
    }

    private static int modifyColorLight(int color, int factor) {
        int red = ColorHelper.getRed(color);
        int green = ColorHelper.getGreen(color);
        int blue = ColorHelper.getBlue(color);
        red = ColorHelper.updateComponent(red, factor *= 16);
        green = ColorHelper.updateComponent(green, factor);
        blue = ColorHelper.updateComponent(blue, factor);
        return ColorHelper.getColor(red, green, blue);
    }

    public static boolean isLightColor(int color) {
        int light = LightHelper.getLight(color);
        return light > 127;
    }

    public static int getLight(int color) {
        int red = ColorHelper.getRed(color);
        int green = ColorHelper.getGreen(color);
        int blue = ColorHelper.getBlue(color);
        return (int)((float)red * 0.299f + (float)green * 0.587f + (float)blue * 0.114f);
    }

    public static int getMostContrastingColor(int colorToContrast) {
        return LightHelper.getMostContrastingColor(colorToContrast, 0xFFFFFF, 0);
    }

    public static int getMostContrastingColor(int colorToContrast, int color1, int color2) {
        if (LightHelper.isLightColor(colorToContrast)) {
            return LightHelper.getDarkestColor(color1, color2);
        }
        return LightHelper.getLightestColor(color1, color2);
    }
}

