/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.support;

import ej.annotation.Nullable;

public abstract class CharacterSeparatedList {
    protected static final char CR = '\r';
    protected static final char HT = '\t';
    protected static final char LF = '\n';
    protected static final char SP = ' ';
    @Nullable
    protected String currentString;
    protected char separator;

    public CharacterSeparatedList(char separator) {
        this.separator = separator;
    }

    private static boolean isLWS(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    protected void endParse() {
    }

    protected abstract StringBuilder generate(StringBuilder var1);

    protected abstract void initializeNbTokens(int var1);

    protected abstract void newToken(int var1, int var2, int var3);

    public void parse(String str) {
        this.parse(str, 0, str.length());
    }

    public void parse(@Nullable String str, int start, int stop) {
        int next;
        this.currentString = str;
        if (str == null) {
            return;
        }
        int nbTokens = 1;
        int ptr = start;
        while ((next = str.indexOf(this.separator, ptr)) != -1 && next <= stop) {
            ++nbTokens;
            ptr = next + 1;
        }
        this.initializeNbTokens(nbTokens);
        ptr = start;
        int i = 0;
        while (i < nbTokens) {
            int endEncoding = str.indexOf(this.separator, ptr);
            if (endEncoding == -1) {
                endEncoding = stop;
            }
            if (endEncoding > stop) {
                endEncoding = stop;
            }
            int tokenStart = ptr;
            while (CharacterSeparatedList.isLWS(str.charAt(tokenStart))) {
                ++tokenStart;
            }
            int tokenStop = endEncoding;
            while (CharacterSeparatedList.isLWS(str.charAt(tokenStop - 1))) {
                --tokenStop;
            }
            this.newToken(i, tokenStart, tokenStop);
            ptr = endEncoding + 1;
            ++i;
        }
        this.endParse();
    }
}

