/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http;

import ej.annotation.Nullable;
import java.util.Date;

public class Cookie {
    @Nullable
    private final String name;
    @Nullable
    private final String value;
    @Nullable
    private String domain;
    @Nullable
    private String path;
    private int maxAge;
    @Nullable
    private Date expires;
    private boolean secured;
    private boolean httpOnly;
    @Nullable
    private SameSite sameSite;

    Cookie(@Nullable String name, @Nullable String value, @Nullable String domain, @Nullable String path, int maxAge, @Nullable Date expires, boolean secured, boolean httpOnly, @Nullable SameSite sameSite) {
        this(name, value, maxAge);
        this.domain = domain;
        this.path = path;
        this.maxAge = maxAge;
        this.expires = expires != null ? (Date)expires.clone() : null;
        this.secured = secured;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
    }

    Cookie(@Nullable String name, @Nullable String value, int maxAge) {
        this.name = name;
        this.value = value;
        this.maxAge = maxAge;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    @Nullable
    public Date getExpires() {
        return this.expires != null ? (Date)this.expires.clone() : null;
    }

    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isSecure() {
        return this.secured;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Nullable
    public SameSite getSameSite() {
        return this.sameSite;
    }

    public String toString() {
        SameSite site;
        StringBuilder cookie = new StringBuilder();
        cookie.append(this.name).append("=").append(this.value);
        Date expires = this.expires;
        if (expires != null) {
            cookie.append("; Expires=").append(expires.toString());
        }
        if (this.maxAge != 0) {
            cookie.append("; Max-Age=").append(this.maxAge);
        }
        if (this.domain != null && !this.domain.isEmpty()) {
            cookie.append("; Domain=").append(this.domain);
        }
        if (this.path != null && !this.path.isEmpty()) {
            cookie.append("; Path=").append(this.path);
        }
        if (this.secured) {
            cookie.append("; Secure");
        }
        if (this.httpOnly) {
            cookie.append("; HttpOnly");
        }
        if ((site = this.sameSite) != null) {
            cookie.append("; SameSite=").append(site.name());
        }
        return cookie.toString();
    }

    public static final class Builder {
        @Nullable
        private String name = null;
        @Nullable
        private String value = null;
        @Nullable
        private Date expires = null;
        @Nullable
        private String domain = null;
        @Nullable
        private String path = null;
        private int maxAge = 0;
        private boolean secured = false;
        private boolean httpOnly = false;
        @Nullable
        private SameSite sameSite = null;

        private Builder() {
        }

        public Builder name(@Nullable String name) {
            if (name == null || name.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            return this;
        }

        public Builder value(@Nullable String value) {
            if (value == null || value.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.value = value;
            return this;
        }

        public Builder expires(@Nullable Date expires) {
            if (expires == null) {
                throw new IllegalArgumentException();
            }
            this.expires = (Date)expires.clone();
            return this;
        }

        public Builder domain(@Nullable String domain) {
            if (domain == null || domain.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.domain = domain;
            return this;
        }

        public Builder path(@Nullable String path) {
            if (path == null || path.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.path = path;
            return this;
        }

        public Builder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder secure() {
            this.secured = true;
            return this;
        }

        public Builder httpOnly() {
            this.httpOnly = true;
            return this;
        }

        public Builder sameSite(@Nullable SameSite sameSite) {
            if (sameSite == null) {
                throw new IllegalArgumentException();
            }
            this.sameSite = sameSite;
            return this;
        }

        public Cookie build() {
            return new Cookie(this.name, this.value, this.domain, this.path, this.maxAge, this.expires, this.secured, this.httpOnly, this.sameSite);
        }
    }

    public static enum SameSite {
        Strict,
        Lax,
        None;

    }
}

