package ej.ecom.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/** 
 * This interface is implemented by a {@link Connection} that is able to open an {@link OutputStream}.
 */
public interface OutputConnection extends Connection {

	 /** 
     * Open an {@link OutputStream}.
     * @throws IOException if a stream is already open
     * @return the open {@link OutputStream}.
     */
    public OutputStream openOutputStream() throws IOException;

    /** 
     * Open a {@link OutputStream}.
     * @throws IOException if a stream is already open
     * @return the open {@link DataOutputStream}.
     */
    public DataOutputStream openDataOutputStream() throws IOException;

}
