/*
 * Java
 *
 * Copyright 2015-2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.util;

/**
 * This class provides utility methods related to the device.
 */
public class Device {

	/**
	 * Private constructor. This class is not intended to be instantiated as it only offers static methods.
	 */
	private Device() {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of the architecture of the device.
	 *
	 * @return the name of the architecture of the device.
	 */
	public static String getArchitecture() {
		throw new RuntimeException();
	}

	/**
	 * Returns the ID of the device. This identifier is guaranteed to be unique to all devices with the same
	 * architecture.
	 *
	 * @return the ID of the device.
	 */
	public static byte[] getId() {
		throw new RuntimeException();
	}

	/**
	 * Reboots the device.
	 */
	public static void reboot() {
		throw new RuntimeException();
	}
}
