/*
 * Java
 *
 * Copyright 2021-2025 MicroEJ Corp.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.microvg.test;

import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import ej.microui.display.Colors;
import ej.microui.display.Display;
import ej.microui.display.GraphicsContext;
import ej.microvg.BlendMode;
import ej.microvg.Matrix;
import ej.microvg.Path;
import ej.microvg.VectorGraphicsPainter;
import ej.microvg.VectorGraphicsPainter.FillType;

/**
 * Tests fill types.
 */
@SuppressWarnings("nls")
public class TestFillType {

	/**
	 * Starts MicroUI.
	 */
	@BeforeClass
	public static void pre() {
		TestUtilities.startMicroUI();
	}

	/**
	 * Stops MicroUI.
	 */
	@AfterClass
	public static void post() {
		TestUtilities.stopMicroUI();
	}

	/**
	 * Resets the content of the screen to black.
	 */
	@Before
	public static void preTest() {
		TestUtilities.clearScreen();
	}

	/**
	 * Tests drawing a star with {@link FillType#EVEN_ODD}.
	 */
	@Test
	public static void testStarEvenOdd() {
		Display display = Display.getDisplay();
		GraphicsContext g = display.getGraphicsContext();

		Path path = new Path();
		path.moveTo(0, 35);
		path.lineTo(100, 35);
		path.lineTo(20, 100);
		path.lineTo(50, 0);
		path.lineTo(80, 100);
		path.close();

		Matrix matrix = new Matrix();
		matrix.setTranslate(50, 50);
		g.setColor(Colors.RED);
		VectorGraphicsPainter.fillPath(g, path, matrix, FillType.EVEN_ODD, 0xff, BlendMode.SRC_OVER);
		display.flush();

		TestUtilities.check("top", 100, 55, g, Colors.RED);
		TestUtilities.check("left", 55, 85, g, Colors.RED);
		TestUtilities.check("right", 145, 85, g, Colors.RED);
		TestUtilities.check("bottom left", 73, 145, g, Colors.RED);
		TestUtilities.check("bottom right", 127, 145, g, Colors.RED);
		TestUtilities.check("center", 100, 100, g, TestUtilities.BACKGROUND_COLOR);
	}

	/**
	 * Tests drawing a star with {@link FillType#WINDING}.
	 */
	@Test
	public static void testStarWinding() {
		Display display = Display.getDisplay();
		GraphicsContext g = display.getGraphicsContext();

		Path path = new Path();
		path.moveTo(0, 35);
		path.lineTo(100, 35);
		path.lineTo(20, 100);
		path.lineTo(50, 0);
		path.lineTo(80, 100);
		path.close();

		Matrix matrix = new Matrix();
		matrix.setTranslate(50, 50);
		g.setColor(Colors.RED);
		VectorGraphicsPainter.fillPath(g, path, matrix, FillType.WINDING, 0xff, BlendMode.SRC_OVER);
		display.flush();

		TestUtilities.check("top", 100, 55, g, Colors.RED);
		TestUtilities.check("left", 55, 85, g, Colors.RED);
		TestUtilities.check("right", 145, 85, g, Colors.RED);
		TestUtilities.check("bottom left", 73, 145, g, Colors.RED);
		TestUtilities.check("bottom right", 127, 145, g, Colors.RED);
		TestUtilities.check("center", 100, 100, g, Colors.RED);
	}

}
