/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class StartScanningCommand extends Command<Boolean> {

	private final byte filterAction;
	private final byte filterType;
	private final byte[] filterData;
	private final int filterDataSize;

	public StartScanningCommand(byte filterAction, byte filterType, byte[] filterData, int filterDataSize) {
		this.filterAction = filterAction;
		this.filterType = filterType;
		this.filterData = filterData;
		this.filterDataSize = filterDataSize;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_START_SCANNING;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendInt(this.filterAction);
		sender.sendInt(this.filterType);
		sender.sendByteArray(this.filterData, 0, this.filterDataSize);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
