/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.bvi;

import ej.drawing.LLDWPainter.DrawingCap;
import ej.microui.display.MicroUIGraphicsContext;

/**
 * VGLite specific drawer for the buffer vector images.
 * <p>
 * It supports all the drawing except the thick faded shapes with a fade greater than 1.
 */
public class VgliteBufferedVectorImageDrawer extends BufferedVectorImageDrawer {

	@Override
	public void drawLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
		getDefaultDrawer().drawLine(gc, x1, y1, x2, y2);
	}

	@Override
	public void drawHorizontalLine(MicroUIGraphicsContext gc, int x1, int x2, int y) {
		getDefaultDrawer().drawHorizontalLine(gc, x1, x2, y);
	}

	@Override
	public void drawVerticalLine(MicroUIGraphicsContext gc, int x, int y1, int y2) {
		getDefaultDrawer().drawVerticalLine(gc, x, y1, y2);
	}

	@Override
	public void fillRectangle(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
		getDefaultDrawer().fillRectangle(gc, x1, y1, x2, y2);
	}

	@Override
	public void drawRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth,
			int arcHeight) {
		getDefaultDrawer().drawRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
	}

	@Override
	public void fillRoundedRectangle(MicroUIGraphicsContext gc, int x, int y, int width, int height, int arcWidth,
			int arcHeight) {
		getDefaultDrawer().fillRoundedRectangle(gc, x, y, width, height, arcWidth, arcHeight);
	}

	@Override
	public void drawCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
		getDefaultDrawer().drawCircleArc(gc, x, y, diameter, startAngle, arcAngle);
	}

	@Override
	public void fillCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle, float arcAngle) {
		getDefaultDrawer().fillCircleArc(gc, x, y, diameter, startAngle, arcAngle);
	}

	@Override
	public void drawEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle,
			float arcAngle) {
		getDefaultDrawer().drawEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
	}

	@Override
	public void fillEllipseArc(MicroUIGraphicsContext gc, int x, int y, int width, int height, float startAngle,
			float arcAngle) {
		getDefaultDrawer().fillEllipseArc(gc, x, y, width, height, startAngle, arcAngle);
	}

	@Override
	public void drawCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
		getDefaultDrawer().drawCircle(gc, x, y, diameter);
	}

	@Override
	public void fillCircle(MicroUIGraphicsContext gc, int x, int y, int diameter) {
		getDefaultDrawer().fillCircle(gc, x, y, diameter);
	}

	@Override
	public void drawEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
		getDefaultDrawer().drawEllipse(gc, x, y, width, height);
	}

	@Override
	public void fillEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height) {
		getDefaultDrawer().fillEllipse(gc, x, y, width, height);
	}

	@Override
	public void drawThickFadedPoint(MicroUIGraphicsContext gc, int x, int y, int thickness, int fade) {
		if (isCompatibleFade(fade)) {
			getDefaultDrawer().drawThickFadedPoint(gc, x, y, thickness, fade);
		} else {
			super.drawThickFadedPoint(gc, x, y, thickness, fade);
		}
	}

	@Override
	public void drawThickFadedLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness, int fade,
			DrawingCap start, DrawingCap end) {
		if (isCompatibleFade(fade)) {
			getDefaultDrawer().drawThickFadedLine(gc, x1, y1, x2, y2, thickness, fade, start, end);
		} else {
			super.drawThickFadedLine(gc, x1, y1, x2, y2, thickness, fade, start, end);
		}
	}

	@Override
	public void drawThickFadedCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness, int fade) {
		if (isCompatibleFade(fade)) {
			getDefaultDrawer().drawThickFadedCircle(gc, x, y, diameter, thickness, fade);
		} else {
			super.drawThickFadedCircle(gc, x, y, diameter, thickness, fade);
		}
	}

	@Override
	public void drawThickFadedCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle,
			float arcAngle, int thickness, int fade, DrawingCap start, DrawingCap end) {
		if (isCompatibleFade(fade)) {
			getDefaultDrawer().drawThickFadedCircleArc(gc, x, y, diameter, startAngle, arcAngle, thickness, fade, start,
					end);
		} else {
			super.drawThickFadedCircleArc(gc, x, y, diameter, startAngle, arcAngle, thickness, fade, start, end);
		}
	}

	@Override
	public void drawThickFadedEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness,
			int fade) {
		if (isCompatibleFade(fade)) {
			getDefaultDrawer().drawThickFadedEllipse(gc, x, y, width, height, thickness, fade);
		} else {
			super.drawThickFadedEllipse(gc, x, y, width, height, thickness, fade);
		}
	}

	@Override
	public void drawThickLine(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2, int thickness) {
		getDefaultDrawer().drawThickLine(gc, x1, y1, x2, y2, thickness);
	}

	@Override
	public void drawThickCircle(MicroUIGraphicsContext gc, int x, int y, int diameter, int thickness) {
		getDefaultDrawer().drawThickCircle(gc, x, y, diameter, thickness);
	}

	@Override
	public void drawThickEllipse(MicroUIGraphicsContext gc, int x, int y, int width, int height, int thickness) {
		getDefaultDrawer().drawThickEllipse(gc, x, y, width, height, thickness);
	}

	@Override
	public void drawThickCircleArc(MicroUIGraphicsContext gc, int x, int y, int diameter, float startAngle,
			float arcAngle, int thickness) {
		getDefaultDrawer().drawThickCircleArc(gc, x, y, diameter, startAngle, arcAngle, thickness);
	}

	/**
	 * A fade higher than 1 is not compatible with VG-Lite
	 */
	private static boolean isCompatibleFade(int fade) {
		return fade <= 1;
	}

}
