/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg.bvi;

import java.awt.geom.GeneralPath;

import ej.microui.display.LLUIPainter;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.LLVGConstants;
import ej.microvg.paint.VGPaint;

/**
 * Nema specific drawer for the buffer vector images.
 * <p>
 * <ul>
 * <li>It supports the drawing of fill rectangles.</li>
 * <li>It supports the drawing of VG paths, except blend modes SCREEN and MULTIPLY (not supported by the GPU).</li>
 * </ul>
 */
public class NemaBufferedVectorImageDrawer extends BufferedVectorImageDrawer {

	@Override
	public void fillRectangle(MicroUIGraphicsContext gc, int x1, int y1, int x2, int y2) {
		getDefaultDrawer().fillRectangle(gc, x1, y1, x2, y2);
	}

	@Override
	public void drawPath(MicroUIGraphicsContext gc, GeneralPath path, float x, float y, float[] matrix, int fillRule,
			int blend, VGPaint paint) {
		if (blend == LLVGConstants.BLEND_SCREEN || blend == LLVGConstants.BLEND_MULTIPLY) {
			gc.reportError(LLUIPainter.DRAWING_LOG_NOT_IMPLEMENTED);
		} else {
			super.drawPath(gc, path, x, y, matrix, fillRule, blend, paint);
		}
	}

}
