/*
 * Copyright 2015-2018 IS2T. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break IS2T warranties on the whole library.
 */
package ej.service.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import ej.annotation.Nullable;

/**
 * Service loader that retrieves services implementations from a property file.
 */
public class FilePropertiesServiceLoader extends DependencyInjectionServiceLoader {

	private final String file;

	/**
	 * Creates a file properties service loader.
	 *
	 * @param path
	 *            the properties file path.
	 */
	public FilePropertiesServiceLoader(String path) {
		this.file = path;
	}

	@Override
	@Nullable
	protected String getImplementationName(String serviceName) {
		Properties properties = new Properties();
		try (InputStream is = FilePropertiesServiceLoader.class.getResourceAsStream(this.file)) {
			properties.load(is);
		} catch (IOException | NullPointerException e) {
			// cannot read file
		}
		return properties.getProperty(serviceName);
	}
}
