#!/bin/bash
#
# BASH
#
# Copyright 2021-2024 MicroEJ Corp. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be found with this software.

# 'build.sh' implementation for MicroEJ Linux builds.

# 'build.sh' is responsible for producing the executable file 
# then copying this executable file to the current directory where it has been executed to a file named 'application.out'

# Save application current directory
CURRENT_DIRECTORY=$(pwd)
cd $(dirname "$0")/

unset LD_LIBRARY_PATH

# Setup build environment variables
. set_project_env.sh

CC=$CC CCASM=$CCASM FLAGS=$FLAGS ASMFLAGS=$ASMFLAGS make -C $(dirname "${1:-$0}")/.. -f scripts/Makefile TARGET=$CURRENT_DIRECTORY/application.out

if [ $? -ne 0 ];
then
   exit -1
fi

# Copy the map file
cp $(dirname $0)/../build/microej_gcc.map $CURRENT_DIRECTORY/application.map

if [ $? -ne 0 ];
then
   exit -1
fi

echo "The application executable file has been generated here: $CURRENT_DIRECTORY/application.out"
# Restore application directory
cd $CURRENT_DIRECTORY/
