/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth.util;

/**
 * Signals that the desired Bluetooth attribute could not be found.
 */
public class AttributeNotFoundException extends Exception {

	private static final long serialVersionUID = -2516583053635833253L;

	/**
	 * Constructs a <code>BluetoothAttributeNotFoundException</code> with no detail message.
	 */
	public AttributeNotFoundException() {
		super();
	}

	/**
	 * Constructs a <code>BluetoothAttributeNotFoundException</code> with the specified detail message.
	 *
	 * @param s
	 *            the detail message.
	 */
	public AttributeNotFoundException(String s) {
		super(s);
	}
}
