/*
 * Copyright 2014-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.motion.constant;

import ej.motion.Function;

/**
 * Represents a constant motion that is always at the stop value.
 */
public class ConstantFunction implements Function {

	/**
	 * Singleton to avoid creating several instances.
	 */
	public static final ConstantFunction INSTANCE = new ConstantFunction();

	private ConstantFunction() {
	}

	@Override
	public float computeValue(float t) {
		return 1.0f;
	}

}
