/*
 * Copyright (c) 1999, 2020, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2021-2022 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package java.security.spec;

/**
 * This class specifies the set of parameters used to generate an RSA key pair.
 *
 * @author Jan Luehe
 *
 * @see java.security.KeyPairGenerator#initialize(java.security.spec.AlgorithmParameterSpec)
 *
 * @since 1.3
 */

public class RSAKeyGenParameterSpec implements AlgorithmParameterSpec {

	/**
	 * The public-exponent value F0 = 3.
	 */
	public static final int F0 = 3;

	/**
	 * The public exponent-value F4 = 65537.
	 */
	public static final int F4 = 65537;

	/**
	 * Constructs a new {@code RSAKeyGenParameterSpec} object from the given keysize, public-exponent value, and null
	 * key parameters.
	 *
	 * @param keysize
	 *            the modulus size (specified in number of bits)
	 * @param publicExponent
	 *            the public exponent
	 */
	public RSAKeyGenParameterSpec(int keysize, int publicExponent) {
		throw new RuntimeException();
	}

	/**
	 * Returns the keysize.
	 *
	 * @return the keysize.
	 */
	public int getKeysize() {
		throw new RuntimeException();
	}

	/**
	 * Returns the public-exponent value.
	 *
	 * @return the public-exponent value.
	 */
	public int getPublicExponent() {
		throw new RuntimeException();
	}

}
