/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2018-2022 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package java.security.spec;

/**
 * This class represents the ASN.1 encoding of a private key, encoded according to the ASN.1 type
 * {@code PrivateKeyInfo}. The {@code PrivateKeyInfo} syntax is defined in the PKCS#8 standard as follows:
 *
 * <pre>
 * PrivateKeyInfo ::= SEQUENCE {
 *   version Version,
 *   privateKeyAlgorithm PrivateKeyAlgorithmIdentifier,
 *   privateKey PrivateKey,
 *   attributes [0] IMPLICIT Attributes OPTIONAL }
 *
 * Version ::= INTEGER
 *
 * PrivateKeyAlgorithmIdentifier ::= AlgorithmIdentifier
 *
 * PrivateKey ::= OCTET STRING
 *
 * Attributes ::= SET OF Attribute
 * </pre>
 *
 * @author Jan Luehe
 *
 *
 * @see java.security.Key
 * @see java.security.KeyFactory
 * @see KeySpec
 * @see EncodedKeySpec
 *
 * @since 1.2
 */

public class PKCS8EncodedKeySpec extends EncodedKeySpec {

	/**
	 * Creates a new PKCS8EncodedKeySpec with the given encoded key.
	 *
	 * @param encodedKey
	 *            the key, which is assumed to be encoded according to the PKCS #8 standard. The contents of the array
	 *            are copied to protect against subsequent modification.
	 * @exception NullPointerException
	 *                if {@code encodedKey} is null.
	 */
	public PKCS8EncodedKeySpec(byte[] encodedKey) {
		super(encodedKey);
	}

	/**
	 * Returns the key bytes, encoded according to the PKCS #8 standard.
	 *
	 * @return the PKCS #8 encoding of the key. Returns a new array each time this method is called.
	 */
	@Override
	public byte[] getEncoded() {
		throw new RuntimeException();
	}

	/**
	 * Returns the name of the encoding format associated with this key specification.
	 *
	 * @return the string {@code "PKCS#8"}.
	 */
	@Override
	public final String getFormat() {
		throw new RuntimeException();
	}
}
