/**
 * Java
 * 
 * Copyright 2014 IS2T. All rights reserved
 * IS2T PROPRIETARY/CONFIDENTIAL Use is subject to license terms.
 */
package ej.sni;


/**
 * A pool of resources where resources are allocated at creation time (no lazy allocation).
 */
public abstract class PoolOfLimitedReusableResources extends PoolOfReusableResources {

	/**
	 * Allocate a new pool of resources
	 * 
	 * @param maxNbResources 0 (i.e. unlimited) is not allowed.
	 * @param allocationSize size of allocated resources (in bytes). 0 (i.e. unlimited) is not allowed.
	 */
	public PoolOfLimitedReusableResources(int maxNbResources, int allocationSize) {
		super(maxNbResources);
		throw new RuntimeException();		
	}

	/**
	 * Return size of allocated resources (in bytes).
	 * @return size of allocated resources (in bytes).
	 */
	public int getAllocationSize() {
		throw new RuntimeException();
	}

}
