/*
 * Copyright 2011-2023 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bon;

import java.lang.ref.Reference;

import ej.annotation.Nullable;

/**
 * ReferenceQueue represents a queue of EnqueuedWeakReference. The system is
 * responsible for adding such EnqueuedWeakReference into the ReferenceQueue.
 * <p>
 * There are two ways to retrieve and remove an element from the queue.
 * <ul>
 * <li>{@link #poll()} : returns null if the queue is empty, otherwise returns
 * and removes the first element of the FIFO queue.</li>
 * <li>{@link #remove()} : blocks the current thread until the queue becomes not
 * empty. returns and removes the first element of the FIFO queue.</li>
 * </ul>
 *
 * @param <T>
 *            the type of enqueued objects
 *
 * @see EnqueuedWeakReference
 */
public final class ReferenceQueue<T> {

	/**
	 * Creates an empty {@link Reference} queue.
	 */
	public ReferenceQueue() {
		throw new RuntimeException();
	}

	/**
	 * Queries the queue and returns and removes the first element of the queue. If
	 * the queue is empty, returns <code>null</code>.
	 *
	 * @return EnqueuedWeakReference or <code>null</code>
	 */
	@Nullable
	public EnqueuedWeakReference<T> poll() {
		throw new RuntimeException();
	}

	/**
	 * Queries the queue, returns and removes the first element of the queue. If the
	 * queue is empty, blocks the current thread until the queue gets at least one
	 * element (automatically added by the system).
	 *
	 * @return EnqueuedWeakReference
	 * @throws InterruptedException
	 *             if the thread is interrupted
	 */
	public EnqueuedWeakReference<T> remove() throws InterruptedException {
		throw new RuntimeException();
	}
}