/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright (C) 2015, IS2T - EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.io;

import java.security.Permission;

/**
 * This class represents access to a file or directory.  A FilePermission consists
 * of a pathname and a set of actions valid for that pathname.
 * <P>
 * Pathname is the pathname of the file or directory granted the specified
 * actions. A pathname that ends in "/*" (where "/" is
 * the file separator character, <code>File.separatorChar</code>) indicates
 * all the files and directories contained in that directory. A pathname
 * that ends with "/-" indicates (recursively) all files
 * and subdirectories contained in that directory. A pathname consisting of
 * the special token "&lt;&lt;ALL FILES&gt;&gt;" matches <b>any</b> file.
 * <P>
 * Note: A pathname consisting of a single "*" indicates all the files
 * in the current directory, while a pathname consisting of a single "-"
 * indicates all the files in the current directory and
 * (recursively) all files and subdirectories contained in the current
 * directory.
 * <P>
 * The actions to be granted are passed to the constructor in a string containing
 * a list of one or more comma-separated keywords. The possible keywords are
 * "read", "write", "execute", "delete", and "readlink". Their meaning is
 * defined as follows:
 *
 * <DL>
 *    <DT> read <DD> read permission
 *    <DT> write <DD> write permission
 *    <DT> execute
 *    <DD> execute permission. Allows <code>Runtime.exec</code> to
 *         be called. Corresponds to <code>SecurityManager.checkExec</code>.
 *    <DT> delete
 *    <DD> delete permission. Allows <code>File.delete</code> to
 *         be called. Corresponds to <code>SecurityManager.checkDelete</code>.
 * </DL>
 * <P>
 * The actions string is converted to lowercase before processing.
 * <P>
 * Be careful when granting FilePermissions. Think about the implications
 * of granting read and especially write access to various files and
 * directories. The "&lt;&lt;ALL FILES&gt;&gt;" permission with write action is
 * especially dangerous. This grants permission to write to the entire
 * file system. One thing this effectively allows is replacement of the
 * system binary, including the JVM runtime environment.
 *
 * <p>Please note: Code can always read a file from the same
 * directory it's in (or a subdirectory of that directory); it does not
 * need explicit permission to do so.
 *
 * @see java.security.Permission
 *
 *
 * @author Marianne Mueller
 * @author Roland Schemers
 * @since 1.2
 *
 * @serial exclude
 */

public final class FilePermission extends Permission implements Serializable {

	/**
	 * Creates a new FilePermission object with the specified actions.
	 * <i>path</i> is the pathname of a file or directory, and <i>actions</i>
	 * contains a comma-separated list of the desired actions granted on the
	 * file or directory. Possible actions are
	 * "read", "write", "execute", "delete", and "readlink".
	 *
	 * <p>A pathname that ends in "/*" (where "/" is
	 * the file separator character, <code>File.separatorChar</code>)
	 * indicates all the files and directories contained in that directory.
	 * A pathname that ends with "/-" indicates (recursively) all files and
	 * subdirectories contained in that directory. The special pathname
	 * "&lt;&lt;ALL FILES&gt;&gt;" matches any file.
	 *
	 * <p>A pathname consisting of a single "*" indicates all the files
	 * in the current directory, while a pathname consisting of a single "-"
	 * indicates all the files in the current directory and
	 * (recursively) all files and subdirectories contained in the current
	 * directory.
	 *
	 * <p>A pathname containing an empty string represents an empty path.
	 *
	 * @param path the pathname of the file/directory.
	 * @param actions the action string.
	 *
	 * @throws IllegalArgumentException
	 *          If actions is <code>null</code>, empty or contains an action
	 *          other than the specified possible actions.
	 */
	public FilePermission(String path, String actions) {
		super(path);
		throw new RuntimeException();
	}

	/**
	 * Checks if this FilePermission object "implies" the specified permission.
	 * <P>
	 * More specifically, this method returns true if:
	 * <ul>
	 * <li> <i>p</i> is an instanceof FilePermission,
	 * <li> <i>p</i>'s actions are a proper subset of this
	 * object's actions, and
	 * <li> <i>p</i>'s pathname is implied by this object's
	 *      pathname. For example, "/tmp/*" implies "/tmp/foo", since
	 *      "/tmp/*" encompasses all files in the "/tmp" directory,
	 *      including the one named "foo".
	 * </ul>
	 *
	 * @param p the permission to check against.
	 *
	 * @return <code>true</code> if the specified permission is not
	 *                  <code>null</code> and is implied by this object,
	 *                  <code>false</code> otherwise.
	 */
	@Override
	public boolean implies(Permission p) {
		throw new RuntimeException();
	}

	/**
	 * Checks two FilePermission objects for equality. Checks that <i>obj</i> is
	 * a FilePermission, and has the same pathname and actions as this object.
	 *
	 * @param obj the object we are testing for equality with this object.
	 * @return <code>true</code> if obj is a FilePermission, and has the same
	 *          pathname and actions as this FilePermission object,
	 *          <code>false</code> otherwise.
	 */
	@Override
	public boolean equals(Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Returns the hash code value for this object.
	 *
	 * @return a hash code value for this object.
	 */
	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Returns the "canonical string representation" of the actions.
	 * That is, this method always returns present actions in the following order:
	 * read, write, execute, delete, readlink. For example, if this FilePermission
	 * object allows both write and read actions, a call to <code>getActions</code>
	 * will return the string "read,write".
	 *
	 * @return the canonical string representation of the actions.
	 */
	@Override
	public String getActions() {
		throw new RuntimeException();
	}

}

