/*
 * Copyright 2019-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.storage.util;

import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageBuilder;
import ej.util.message.basic.BasicMessageLogger;

/**
 * Provides a message logger to log all messages for storage.
 */
public class StorageMessage {

	/**
	 * Wadapps common message builder.
	 */
	public static final BasicMessageBuilder BUILDER = new BasicMessageBuilder();
	/**
	 * Wadapps common message logger.
	 */
	public static final MessageLogger LOGGER = new BasicMessageLogger(BUILDER);

	/**
	 * Wadapps common message category.
	 */
	public static final String CATEGORY = "Storage"; //$NON-NLS-1$

	/**
	 * Error occurs when starting an app.
	 */
	public static final int ERROR_ON_START = 0;

	/**
	 * Error occurs when stopping an app.
	 */
	public static final int ERROR_ON_STOP = 1;

	/**
	 * Error occurs when a storage ID is empty.
	 */
	public static final int ID_IS_ZERO_LENGTH = 101;

	/**
	 * Error occurs when a storage ID does not start with a letter.
	 */
	public static final int ID_DOES_NOT_START_WITH_LETTER = 102;

	/**
	 * Error occurs when a storage ID contains an invalid character.
	 */
	public static final int ID_CONTAINS_INVALID_CHARACTER = 103;

	/**
	 * Error occurs when an offset negative.
	 */
	public static final int OFFSET_IS_NEGATIVE = 104;

	private StorageMessage() {
	}

}
