/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothUuid</code> class represents the UUID of a service or attribute.
 * <p>
 * UUIDs may be created from a string representing a 128-bit UUID or from an integer containing a 16-bit UUID.
 * <p>
 * A string representation of a UUID may be retrieved by calling the method {@link #toString toString()} of the object.
 */
public class BluetoothUuid {

	/**
	 * Creates a UUID from a string.
	 *
	 * @param string
	 *            a string representing a 128-bit UUID.
	 * @throws IllegalArgumentException
	 *             if the given string is null or if is does not represent a 128-bit UUID.
	 */
	public BluetoothUuid(String string) {
		throw new RuntimeException();
	}

	/**
	 * Creates a UUID from an integer.
	 *
	 * @param value
	 *            an integer representing a 16-bit UUID.
	 * @throws IllegalArgumentException
	 *             if the given value does not represent a 16-bit UUID.
	 */
	public BluetoothUuid(int value) {
		throw new RuntimeException();
	}
}
