/*
 * Copyright 2020-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.soar;

/**
 * Exception thrown when an error is encountered during
 * {@link FeatureOptimizer#build(java.io.InputStream, java.io.OutputStream)}
 */
public class FeatureOptimizerException extends Exception {

	/**
	 * @param errorCode
	 *            an implementation specific error code. Please consult associated documentation.
	 */
	public FeatureOptimizerException(int errorCode) {
		throw new RuntimeException();
	}

	/**
	 * @param errorCode
	 *            an implementation specific error code. Please consult associated documentation.
	 * @param message
	 *            a string message related to the error code.
	 */
	public FeatureOptimizerException(int errorCode, String message) {
		throw new RuntimeException();
	}

	/**
	 * @param errorCode
	 *            an implementation specific error code. Please consult associated documentation.
	 * @param throwable
	 *            an underlying error related to the error code.
	 */
	public FeatureOptimizerException(int errorCode, Throwable throwable) {
		throw new RuntimeException();
	}

	/**
	 * @return the implementation specific error code.
	 */
	public int getErrorCode() {
		throw new RuntimeException();
	}
}
