/*
 * Java
 *
 * Copyright 2014-2015 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

import java.io.IOException;
import java.util.List;

public interface RemoteConnection extends CommandSender, CommandReader {

	/**
	 * Reads the parameters of a command.
	 * <p>
	 * Method {@link #skipParameters()} must be called after to be ready to read the following command.
	 * 
	 * @return list of the parameters.
	 */
	List<Object> readParameters() throws IOException;

	/**
	 * Sends the given parameters.
	 * 
	 * @param params
	 *            the list of parameters to send.
	 */
	void sendParams(List<Object> params);

	/**
	 * Closes the connection.
	 */
	void close();
}
