# Overview

MicroEJ Foundation Library implementation: `net-ssl-2_2-testsuite`.

# Usage

Add the following line to your `module.ivy`:

    <dependency org="com.microej.pack.net" name="net-ssl-2_2-testsuite" rev="5.0.1"/>

## Properties

Several properties are required in order to configure the SSL test suite.
They need to be prefixed with `microej.java.property.` in the file `microej-testsuite-common.properties` of your test suite configuration project.

Properties that are **required**:

- `remote.machine.ip`: The IP address of the machine executing the test suite.
- `remoteapp.timeout`: Amount of time (in milliseconds) that the remote test will wait before interrupting its execution.
- `netif.name`: The network interface name of the platform that is tested.

## Wi-Fi Network Configuration

If the platform tested uses Wi-Fi for network communication, the following dependency must be added to the test suite configuration project: `<dependency org="com.microej.pack.net" name="net-1_1-testsuite-wifi" rev="2.1.1"/>`.

Also the following properties need to be set:

- `wifi.ssid`: SSID of the network to join for the tests.
- `wifi.passphrase`: Passphrase of the network to join.

# Requirements

This library requires the following Foundation Libraries:

    BON-1.4, EDC-1.3, NET-1.1, SECURITY-1.3, SSL-2.2

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

None.

---

_Copyright 2022-2025 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  