# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [4.0.1] - 2022-04-29

### Fixed

 - Set private-default conf for remote dependency.

## [4.0.0] - 2022-04-14

### Added

  - Add PKI tests.
  - Add the property `remote.machine.timeout` to configure remote application timeout.

### Changed

  - Increase the number of times the client-side of `TestPeerCloseSocketWrite` writes (Server-side doesn't close the socket fast enough).
  - Rename classes package and module.
  - Tests refactoring, properties renaming in order to avoid confusion and add Server Name Indication tests.

### Fixed

  - Remove tests that are not related to the SSL specification.

## [3.1.4] - 2021-05-07

### Fixed

  - Use different ports in ssl tests.
  - Use equals instead of matches to match the current test in init script files.

## [3.1.3] - 2021-04-08

### Fixed

  - Fix remote app initialization (`TestClientAuthentication_5`, `TestClientAuthentication_6`).

## [3.1.2] - 2020-09-08

### Fixed

  - Fix test misconfigured SNI test  (`TestClientAuthentication_6`).

## [3.1.1] - 2020-04-15

### Fixed

  - Update private keys for Mbed TLS.

## [3.1.0] - 2019-02-28

### Added

  - Add tests for TLS SNI feature (Server Name Indication).
  - Testsuite depends on `ej.api.ssl#2.2.+` including SSL/Security foundation libraries split.

### Fixed

  - SSL testsuite fail with error message on `remote.machine.hostname` property not set.

## [3.0.1] - 2018-09-24

### Fixed

  - SSL NonAutoClose test: the server is started twice instead of once and the second start causes a JVM_Bind exception.
  - Chain certificates are set with the same alias and only the last one is added as trusted.

## [3.0.0] - 2018-07-13

### Added

  - Increase the number of times the client-side of `TestPeerCloseSocketWrite` writes (Allow the test run through a VPN/NAT on Linux Virtual machine to work. Server-side doesn't close the socket fast enough).

### Fixed

  - The System current date of SSL test-suite is before the certificate "Not Before" date.

## [2.0.1] - 2017-10-27

### Added

  - Update SSL testsuite certificates which used the deprecated MD5 algorithm and use SHA1 algorithm instead.

## [2.0.0] - 2017-10-10

### Added

  - SSL ServerSocket tests.
  - Bidirectional SSL tests.
  - Add test `TestTrustWrongDateValidity` : Certificate validity check for identical subject (update of certificate validity dates).

## [1.4.0] - 2017-01-17

### Added

  - Add test `TestTrustOnlyFirstInChain`: Check TrustStore with multiple certificate and open connection using the first one.
  - Add test `TestPeerCloseSocketRead`: Check that write return end of file on peer socket close.
  - Add test `TestPeerCloseSocketWrite`: Check that write return connection reset on peer socket close.

## [1.3.0] - 2016-29-12

### Added

  - Update of the dependencies.

## [1.2.0] - 2016-01-11

### Added

  - Certificate chain validation implementation.

## [1.1.0] - 2015-12-31

### Added

  - TrustStore tests added.
  - SSL context automatic recycle tests added.

## [1.0.0] - 2015-12-07

### Added

  - Initial revision.

---

_Copyright 2022 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
