# Overview

This testsuite allows to validate that the Bluetooth library and the Bluetooth implementation of a platform are working correctly.

To run this testsuite, two devices are required. The two devices will be flashed with different firmwares: one device
will run the central application (see `ej.bluetooth.test.central.CompleteFlowTest`) and an other device will run the
peripheral application (see `ej.bluetooth.test.peripheral.CompleteFlowTest`).

The two devices may be two different boards. For examples, you may run the central application on an ESP32-WROVER board
and the peripheral application on a DA14681 board.

## Validating the Bluetooth library

In order to test a new version of the Bluetooth library, use an existing and validated platform, such as the ESP32-WROVER reference platform.
Make sure to build a platform which embeds your new version of the Bluetooth library.

Then, build both firmwares (central and peripheral) using this platform and flash the two devices.
Restart the two devices at the same time and read the traces of both devices to make sure that the tests pass.

## Validating a platform implementation

This testsuite is intended to be passed once the Bluetooth LLAPI has been fully implemented in the platform.
If you want want to test the Bluetooth platform implementation during development, use the Bluetooth Examples instead.

To validate that the central implementation is working correctly, build the central application with the platform which you want to test,
and flash it on your device. The other device should be flashed with the peripheral application using a validated platform, such as the
ESP32-WROVER reference platform.

To validate that the peripheral implementation is working correctly, build the peripheral application with the platform which you want to test,
and flash it on your device. The other device should be flashed with the central application using a validated platform, such as the
ESP32-WROVER reference platform.

# Usage

Add the following line to your `module.ivy`:

    <dependency org="com.microej.pack.bluetooth" name="bluetooth-testsuite" rev="2.0.0"/>

# Requirements

This library requires the following Foundation Libraries:

    BLUETOOTH-2.0, BON-1.4, EDC-1.3

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A

# Restrictions

None.

---
_Copyright 2018-2020 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  
