<!--
	Markdown
	
	Copyright 2019 MicroEJ Corp. All rights reserved.
	MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
-->
# Overview
This component contains the MicroEJ compatible version of Segger SystemView target implementation for FreeRTOS 10.

# Usage
Add the following line to your `module.ivy` or your `ivy.xml`:

    <dependency org="com.microej.clibrary.thirdparty" name="systemview-freertos10" rev="..."/>

For a correct initialization, the following steps must be done in the BSP:

- Register the FreeRTOS MicroJVM task:
```
 TaskHandle_t pvCreatedTask;
 xTaskCreate(xJavaTaskFunction, JAVA_TASK_NAME, JAVA_TASK_STACK_SIZE, NULL, JAVA_TASK_PRIORITY, &pvCreatedTask);
 SEGGER_SYSVIEW_setMicroJVMTask((U32)pvCreatedTask);
```    
- Configure `SYSVIEW_X_OS_TraceAPI` to call `LLMJVM_MONITOR_SYSTEMVIEW_send_task_list()` in addition to the default `pfSendTaskList()`

- Double check the value of the RAM base address (`SYSVIEW_RAM_BASE`) that should be lower than the MicroJVM task ids.

# Requirements
N/A

# Dependencies
_All dependencies are retrieved transitively by Ivy resolver_.

# Source
N/A

# Restrictions
None.
