# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [3.0.0] - 2023-05-03

### Added

  - Add support for multiple Graphics Context output formats.
  - Add support for multiple Image input formats.
  - Add stub implementations for all MicroUI and Drawing libraries algorithms.

### Changed

  - Make the CCO compatible with UI pack 13.5.0 and higher.

### Migration Guide

  - [VEE Port configuration project] 
  		- Fetch UI Pack 13.5.0 and CCO MicroUI 3.0.0.
  - [BSP project] 
  		- Delete the VEE Port `include` folder (often `/platform/inc`).
  		- Delete the properties file `cco_microui.properties`.
  		- In the C project configuration, include the new C files `ui_drawing.c`, `ui_image_drawing.c` and `ui_drawing_stub.c`.
  - Build the VEE Port and the BSP.
  
## [2.0.1] - 2022-12-16

### Changed

- Do not draw thick shapes when thickness and fade are equal to zero.

## [2.0.0] - 2022-08-31

- Compatible with MicroEJ UI Pack 13.3.0 or higher.

### Changed

- Improve `drawImage`: identify faster use cases (copy an image and draw a region with overlap).
- Use new MicroEJ UI Pack 13.3.0 API: `UI_DRAWING_copyImage` and `UI_DRAWING_drawRegion`. 
- Use new MicroUI's native functions declaration (not backward compatible).

## [1.1.1] - 2022-04-27

- Compatible with MicroEJ UI Pack 13.1.0 or higher.

### Fixed

- Fix the license and copyrights: use BSD License.
- Fix Misra rules.

## [1.1.0] - 2021-07-16

- Compatible with MicroEJ UI Pack 13.1.0 or higher.

### Added

- Add MicroUI events logger.
- Add MicroUI images heap allocator.

### Fixed

- Fix comments in `LLUI_PAINTER_impl.c` and `LLDW_PAINTER_impl.c`.
- Ignore a drawing when at least one scaling factor is equal to zero.

## [1.0.3] - 2020-12-08

- Compatible with MicroEJ UI Pack 13.0.0 or higher.

### Fixed

- Fix missing license file.

## [1.0.2] - 2020-09-02

- Compatible with MicroEJ UI Pack 13.0.0 or higher.

### Changed

- Fix artifact organization.

## [1.0.1] - 2020-07-28

- Compatible with MicroEJ UI Pack 13.0.0 or higher.

### Changed

- Fix MISRA C 2004 rule 13.3.
- Rename some parameters.
- Clamp user's alpha value instead throwing an exception.
- Rename readPixel in writePixel.

## [1.0.0] - 2020-04-09

- Initial revision (deprecated version).
- Implements `LLGRAPHICS_impl.h` and `LLGRAPHICS_EXT_impl.h` functions (MicroUI native functions).
- Log all drawings.
- Dispatch all drawings to the implementation of `DRAWING_impl.h`

---
_Copyright 2020-2023 MicroEJ Corp. All rights reserved._  
_Use of this source code is governed by a BSD-style license that can be found with this software._  
