
# Overview

MicroEJ C Component: `bsp-llmicroui`.

This component (or an equivalent of this component) implements some Low-Level API (LLAPI) of MicroUI-3.x. The following table illustrates the LLAPI implemented in this component:


| LLAPI               | Available in CCO | Chapter                         |
| ------------------- | ---------------- | ------------------------------- |
| LLUI_DISPLAY_impl.h | partially (heap) | [Heap](#heap)                   |
| LLUI_PAINTER_impl.h | yes              | [Painter](#painter)             |
| LLDW_PAINTER_impl.h | yes              | [Painter](#painter)             |
| LLUI_INPUT_impl.h   | partially (log)  | [Events Logger](#events-logger) |


# Heap

## Description

This part (or an equivalent of this component's part) is optional: the MicroUI Graphics Engine already includes an images heap allocator. Like MicroUI Graphics Engine's images heap, the component's images heap is using a best fit allocator. The following list describes the allocator constraints: 
- It requires a header at the beginning of heap section.
- It adds a header and a footer for each allocated block.
- It produces memory fragmentation: it may not not allow to allocate a block whose size is equal to the free memory size.

This component's image heap adds some utility functions to get information about the heap: total size, free size and number of allocated blocks. 

## Implemented LLAPI

This component's part provides the LLAPI implementation of all `LLUI_DISPLAY_IMPL_image_heap_xxx` functions of `LLUI_DISPLAY_impl.h`).

## Usage

To replace the default images heap allocator, the BSP must:

1. Add the C file `LLUI_DISPLAY_HEAP_impl.c` in BSP project.
2. Add the header files directory into the BSP include directories list.

# Painter 

## Description

This part (or an equivalent of this component's part) is mandatory by MicroUI-3.x when the MicroEJ Platform provides a Display. Its aim is to facilitate the MicroUI Painter classes implementation. It manages the MicroEJ Graphics Engine requirements and calls some rendering functions (see `ui_drawing.h` and `dw_drawing.h`). By default, these rendering functions are already implementated as _weak_  functions in the MicroUI Graphics Engine.

The rendering functions can be implementated independently over a GPU or in software in the BSP. Thanks to this component's part, the aim of the rendering functions is simplified: the implementation has just to perform the drawings as expected, without considering the MicroUI Graphics Engine requirements.

This component's part:

- synchronizes drawings with the MicroUI Graphics Engine,
- manages GraphicsContext's clip when possible / required,
- deports the rendering to another files (respectively `ui_drawing.h` and `dw_drawing.h`).

## Implemented LLAPI

This component's part provides:

- the LLAPI implementation of `LLUI_PAINTER_impl.h` (@see MicroUI class Painter),
- the LLAPI implementation of `LLDW_PAINTER_impl.h` (@see Drawing class Painter).

## Usage 

### No Renderer

When the BSP does not provide a renderer (software and / or hardware as a GPU), the BSP must:

1. Include both C files `LLUI_PAINTER_impl.c` and `LLDW_PAINTER_impl.c`. 

The rendering is performed by the MicroUI Graphics Engine in software.

### Additional Renderer

When the BSP provides one or several renderers (software and / or hardware as a GPU), the BSP must:

1. Include both C files `LLUI_PAINTER_impl.c` and `LLDW_PAINTER_impl.c`.
2. Implement one or several functions of `ui_drawing.h` and `dw_drawing.h`.

The non-implemented rendering functions are performed by the MicroUI Graphics Engine in software.

# Events Logger

## Description

This part (or an equivalent of this component's part) is only mandatory by MicroUI-3.x when the BSP is calling `LLUI_INPUT_dump()`. If not included, the call to `LLUI_INPUT_dump()` performs nothing. Its aim is to log the MicroUI events and to provide an events dumper. 

The logger adds some metadata to each MicroUI event in a dedicated array. When the BSP is calling `LLUI_INPUT_dump()`, the logger is using its data to decode the events. Then it uses an implementation of `microui_event_decoder.h` (available in this component) to describe the events.

## Implemented LLAPI

This component's part provides the LLAPI implementation of all the `LLUI_INPUT_IMPL_log_xxx` functions of `LLUI_INPUT_impl.h`).

## Usage

To enable the events logger, the BSP must:

1. Add the C files `LLUI_INPUT_LOG_impl.c` and `microui_event_decoder.c` in BSP project.
2. Add the header files directory into the BSP include directories list.
3. Set the defines in `microui_event_decoder_conf.h` to enable and configure the logger (by default the logger is disabled).

# MicroEJ UI Pack

This compoment is MicroEJ UI Pack dependent: it is compatible with a one or several MicroEJ UI Pack versions. The following table illustrates the compatibility:


| Component | MicroEJ UI Pack   | Comment             |
| --------- | ----------------- | ------------------- |
| 1.1.0     | [13.1.0 - 14.0.0[ | add logger and heap | 
| 1.0.3     | [13.0.0 - 14.0.0[ |                     |
| 1.0.2     | [13.0.0 - 14.0.0[ |                     |
| 1.0.1     | [13.0.0 - 14.0.0[ |                     |
| 1.0.0     | n/a               | deprecated          |

> note: this component is useless (and not compatible) for the MicroEJ UI Packs before version 13.0.0.


# Usage

1. Add the following line to your `module.ivy`:

    @MMM_DEPENDENCY_DECLARATION@

2. Follow **Usage** chapters of each component part.

# Migration Guide

## From UI Pack 13.0.x to 13.1.x and higher

- Follow **Usage** chapters of [Heap](#heap) and [Events Logger](#events-logger).

# Requirements

None.

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A

# Restrictions

None.

---
_Copyright 2020-2021 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  

