/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.module;

import com.microej.kf.util.control.fs.FileSystemResourcesController;
import com.microej.kf.util.control.net.NetResourcesController;
import ej.kf.Feature;
import ej.kf.Feature.State;
import ej.kf.Kernel;
import ej.kf.Module;

/**
 * A sandboxed module interface.
 * <p>
 * It provides APIs to control access to resources used by the module. A module can be an application or the kernel
 * itself.
 * <p>
 * It allows to:
 *
 * <ul>
 * <li>set the file system and the network resources usage thresholds.</li>
 * <li>retrieve the current resources usage state of the module.</li>
 * </ul>
 * <p>
 * A module whose resources usage should be controlled must implement this interface.
 *
 * This interface is implemented by {@link ApplicationModule}.
 */
public interface SandboxedModule {

	/**
	 * Returns the file system resource controller of this module.
	 *
	 * @return the file system resource controller of this module.
	 */
	FileSystemResourcesController getFileSystemResourceController();

	/**
	 * Returns the network resource controller of this module.
	 *
	 * @return the network resource controller of this module.
	 */
	NetResourcesController getNetworkResourceController();

	/**
	 * Returns the associated KF module (a {@link Feature} for an application module or {@link Kernel} for the kernel
	 * module.
	 *
	 * @return the associated KF module.
	 */
	Module getModule();

	/**
	 * Returns the module identifier.
	 *
	 * @return the module identifier.
	 */
	String getIdentifier();

	/**
	 * Returns the state of the module.
	 *
	 * @return the module state.
	 */
	State getState();
}
