/*
 *	Java
 *
 *	Copyright 2015-2016 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Image;

/**
 * This class holds a context in order to draw images with scaling.<br>
 * <p>
 * An image scale instance holds a global state for all drawings. Several instances can be created at the same time.
 * However a default instance is created on MicroUI framework startup and is always available.<br>
 *
 * @since 2.0
 */
public class ImageScale extends AbstractTransform {

	/**
	 * Default instance created on MicroUI framework startup.
	 */
	public static ImageScale Singleton = new ImageScale();

	/**
	 * Returns the current scaling factor.
	 *
	 * @return the current scaling factor.
	 */
	public float getFactor() {
		throw new RuntimeException();
	}

	/**
	 * Set a new scaling factor
	 *
	 * @param factor
	 *            the new scaling factor
	 * @throws IllegalArgumentException
	 *             if <code>factor</code> is lower than or equal to zero
	 */
	public void setFactor(float factor) {
		throw new RuntimeException();
	}

	/**
	 * Draw the {@link Image} in the {@link GraphicsContext} at given anchor position and using the current scaling
	 * factor.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param image
	 *            the {@link Image} to draw
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 */
	public void draw(GraphicsContext gc, Image image, int x, int y, int anchor) {
		throw new RuntimeException();
	}
}
