/*
 * Java
 *
 * Copyright 2010-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.event.generator;

import ej.microui.event.Event;
import ej.microui.event.EventGenerator;

/**
 * Command is an event generator that generates application-level events. Unlike io generators that are related to some
 * hardware input format, the command generator defines its own input format. Basically input and output event are the
 * same. This allows the generation of commands from within MicroUI without relying on an underlying input event format.
 * <p>
 * This class defines constants for a set of basic commands. The commands defined in this class are typical
 * application-level effects of input events. The advantage of using commands rather than specific input events in an
 * application is that the application can be more portable: it is not tied to specific input devices.
 */

public class Command extends EventGenerator {

	/**
	 * The "escape" command constant.<br>
	 */
	public static final int ESC = 0x0000;
	/**
	 * The "back" command constant.<br>
	 */
	public static final int BACK = 0x0001;
	/**
	 * The "up" command constant.<br>
	 */
	public static final int UP = 0x0002;
	/**
	 * The "down" command constant.<br>
	 */
	public static final int DOWN = 0x0003;
	/**
	 * The "left" command constant.<br>
	 */
	public static final int LEFT = 0x0004;
	/**
	 * The "right" command constant.<br>
	 */
	public static final int RIGHT = 0x0005;
	/**
	 * The "select" command constant.<br>
	 */
	public static final int SELECT = 0x0006;
	/**
	 * The "cancel" command constant.<br>
	 */
	public static final int CANCEL = 0x0007;
	/**
	 * The "help" command constant.<br>
	 */
	public static final int HELP = 0x0008;
	/**
	 * The "menu" command constant.<br>
	 */
	public static final int MENU = 0x0009;
	/**
	 * The "exit" command constant.<br>
	 */
	public static final int EXIT = 0x000A;
	/**
	 * The "start" command constant.<br>
	 */
	public static final int START = 0x000B;
	/**
	 * The "stop" command constant.<br>
	 */
	public static final int STOP = 0x000C;
	/**
	 * The "pause" command constant.<br>
	 */
	public static final int PAUSE = 0x000D;
	/**
	 * The "resume" command constant.<br>
	 */
	public static final int RESUME = 0x000E;
	/**
	 * The "copy" command constant.<br>
	 */
	public static final int COPY = 0x000F;
	/**
	 * The "cut" command constant.<br>
	 */
	public static final int CUT = 0x0010;
	/**
	 * The "paste" command constant.<br>
	 */
	public static final int PASTE = 0x0011;
	/**
	 * The "clockwise" command constant.<br>
	 */
	public static final int CLOCKWISE = 0x0012;
	/**
	 * The "anti-clockwise" command constant.<br>
	 */
	public static final int ANTICLOCKWISE = 0x0013;
	/**
	 * The "previous" command constant.<br>
	 */
	public static final int PREVIOUS = 0x0014;
	/**
	 * The "next" command constant.<br>
	 */
	public static final int NEXT = 0x0015;
	/**
	 * The "display" command constant.<br>
	 */
	public static final int DISPLAY = 0x0016;

	/**
	 * Creates a new command event generator.
	 */
	public Command() {
	}

	/**
	 * Gets the event generator's type. Default value is {@link Event#COMMAND}.
	 *
	 * @return the command generator's type
	 */

	@Override
	public int getEventType() {
		throw new RuntimeException();
	}

	/**
	 * Sends the given command to the event generator's listener
	 *
	 * @param command
	 *            the command to be sent
	 */
	public void send(int command) {
		throw new RuntimeException();
	}

}
