/*
 *	Java
 *
 *	Copyright 2010-2015 IS2T. All rights reserved.
 *	IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package ej.microui.display;

/**
 * An <code>ExplicitFlush</code> is a <code>GraphicsContext</code> where flushing data to the screen must be done
 * explicitly by the application. An <code>ExplicitFlush</code> is useful if the <code>Display</code> on which the
 * <code>ExplicitFlush</code> is writing is double buffered. By using an <code>ExplicitFlush</code> the user can choose
 * the best moment to flush its output. If the display is not double buffered, all drawing actions on this
 * <code>GraphicsContext</code> are rendered immediately and the flush method has no effect.
 * 
 * @see GraphicsContext
 * @see Display#getNewExplicitFlush()
 */
public class ExplicitFlush extends GraphicsContext {

	/**
	 * Forbidden constructor: use {@link Display#getNewExplicitFlush()} to get an instance of explicit flush.
	 */
	private ExplicitFlush() {
		throw new RuntimeException();
	}

	/**
	 * Updates the display with the draw actions since the last flush if and only if the display is double buffered.
	 * 
	 * @see Display#isDoubleBuffered()
	 */
	public void flush() {
		throw new RuntimeException();
	}

}
